/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.handlers.AWSClientErrorRetryHandler;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSClientErrorRetryHandlerTest")
public class AWSClientErrorRetryHandlerTest {
    @Test
    public void test401DoesNotRetry() {
        AWSUtils utils = (AWSUtils)EasyMock.createMock(AWSUtils.class);
        BackoffLimitedRetryHandler backoffLimitedRetryHandler = (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        EasyMock.replay((Object[])new Object[]{utils, backoffLimitedRetryHandler, command});
        AWSClientErrorRetryHandler retry = new AWSClientErrorRetryHandler(utils, backoffLimitedRetryHandler, (Set)ImmutableSet.of());
        assert (!retry.shouldRetryRequest(command, HttpResponse.builder().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).build()));
        EasyMock.verify((Object[])new Object[]{utils, backoffLimitedRetryHandler, command});
    }

    @DataProvider(name="codes")
    public Object[][] createData() {
        return new Object[][]{{"RequestTimeout"}, {"OperationAborted"}, {"SignatureDoesNotMatch"}};
    }

    @Test(dataProvider="codes")
    public void test409DoesBackoffAndRetryForCode(String code) {
        AWSUtils utils = (AWSUtils)EasyMock.createMock(AWSUtils.class);
        BackoffLimitedRetryHandler backoffLimitedRetryHandler = (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest putBucket = HttpRequest.builder().method("PUT").endpoint("https://adriancole-blobstore113.s3.amazonaws.com/").build();
        HttpResponse operationAborted = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.CONFLICT.getStatusCode()).payload((Payload)Payloads.newStringPayload((String)String.format("<Error><Code>%s</Code></Error>", code)))).build();
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)putBucket);
        AWSError error = new AWSError();
        error.setCode(code);
        EasyMock.expect((Object)utils.parseAWSErrorFromContent(putBucket, operationAborted)).andReturn((Object)error);
        EasyMock.expect((Object)backoffLimitedRetryHandler.shouldRetryRequest(command, operationAborted)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{utils, backoffLimitedRetryHandler, command});
        AWSClientErrorRetryHandler retry = new AWSClientErrorRetryHandler(utils, backoffLimitedRetryHandler, (Set)ImmutableSet.of((Object)"RequestTimeout", (Object)"OperationAborted", (Object)"SignatureDoesNotMatch"));
        assert (retry.shouldRetryRequest(command, operationAborted));
        EasyMock.verify((Object[])new Object[]{utils, backoffLimitedRetryHandler, command});
    }
}

