/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.sts.STSApi;
import org.jclouds.sts.domain.UserAndSessionCredentials;
import org.jclouds.sts.internal.BaseSTSApiLiveTest;
import org.jclouds.sts.options.AssumeRoleOptions;
import org.jclouds.sts.options.FederatedUserOptions;
import org.jclouds.sts.options.SessionCredentialsOptions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="STSApiLiveTest")
public class STSApiLiveTest
extends BaseSTSApiLiveTest {
    @Test
    protected void testCreateTemporaryCredentials() {
        SessionCredentials creds = ((STSApi)this.api).createTemporaryCredentials(new SessionCredentialsOptions().durationSeconds(TimeUnit.MINUTES.toSeconds(15L)));
        this.checkTemporaryCredentials(creds);
    }

    @Test
    protected void testCreateFederatedUser() {
        UserAndSessionCredentials user = ((STSApi)this.api).createFederatedUser("Bob", new FederatedUserOptions().durationSeconds(TimeUnit.MINUTES.toSeconds(15L)));
        this.checkTemporaryCredentials(user.getCredentials());
        Assert.assertTrue((boolean)user.getUser().getId().contains("Bob"), (String)(user + " id incorrect"));
        Assert.assertTrue((boolean)user.getUser().getArn().contains("Bob"), (String)(user + " arn incorrect"));
        Assert.assertTrue((user.getPackedPolicySize() >= 0 ? 1 : 0) != 0, (String)(user + " policy size negative"));
    }

    @Test
    protected void testAssumeRole() {
        String arnToAssume = this.getTestArn();
        UserAndSessionCredentials role = ((STSApi)this.api).assumeRole(arnToAssume, "session", new AssumeRoleOptions().durationSeconds(TimeUnit.MINUTES.toSeconds(15L)));
        this.checkTemporaryCredentials(role.getCredentials());
        Assert.assertTrue((boolean)role.getUser().getId().contains("session"), (String)(role + " id incorrect"));
        Assert.assertTrue((boolean)role.getUser().getArn().contains("session"), (String)(role + " arn incorrect"));
        Assert.assertTrue((role.getPackedPolicySize() >= 0 ? 1 : 0) != 0, (String)(role + " policy size negative"));
    }

    protected String getTestArn() {
        throw new SkipException("TODO: need to query a valid arn to assume");
    }

    private void checkTemporaryCredentials(SessionCredentials creds) {
        Preconditions.checkNotNull((Object)creds.getAccessKeyId(), (Object)"AccessKeyId cannot be null for TemporaryCredentials.");
        Preconditions.checkNotNull((Object)creds.getSecretAccessKey(), (Object)"SecretAccessKey cannot be null for TemporaryCredentials.");
        Preconditions.checkNotNull((Object)creds.getSessionToken(), (Object)"SessionToken cannot be null for TemporaryCredentials.");
        Preconditions.checkNotNull((Object)creds.getExpiration(), (Object)"Expiration cannot be null for TemporaryCredentials.");
    }
}

