/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.parse;

import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sts.domain.User;
import org.jclouds.sts.domain.UserAndSessionCredentials;
import org.jclouds.sts.parse.GetSessionTokenResponseTest;
import org.jclouds.sts.xml.UserAndSessionCredentialsHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetFederationTokenResponseTest")
public class GetFederationTokenResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/federation_token.xml");
        UserAndSessionCredentials expected = this.expected();
        UserAndSessionCredentialsHandler handler = (UserAndSessionCredentialsHandler)this.injector.getInstance(UserAndSessionCredentialsHandler.class);
        UserAndSessionCredentials result = (UserAndSessionCredentials)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
        Assert.assertEquals((Object)result.getUser(), (Object)expected.getUser());
        Assert.assertEquals((int)result.getPackedPolicySize(), (int)expected.getPackedPolicySize());
    }

    public UserAndSessionCredentials expected() {
        return UserAndSessionCredentials.builder().credentials(new GetSessionTokenResponseTest().expected()).user(User.fromIdAndArn((String)"123456789012:Bob", (String)"arn:aws:sts::123456789012:federated-user/Bob")).packedPolicySize(6).build();
    }
}

