/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.integration;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.jclouds.blobstore.options.PutOptions;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class SwiftBlobIntegrationLiveTest
extends BaseBlobIntegrationTest {
    private static final long PART_SIZE = 0x500000L;
    private InputSupplier<InputStream> oneHundredOneConstitutions;

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        props.setProperty("jclouds.mpu.parts.size", String.valueOf(0x500000L));
        return props;
    }

    public SwiftBlobIntegrationLiveTest() {
        this.provider = System.getProperty("test.swift.provider", "swift");
    }

    @Test(enabled=false)
    public void testGetTwoRanges() {
    }

    @Test
    public void testCreateBlobWithExpiry() throws InterruptedException {
        throw new SkipException("not yet implemented");
    }

    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        super.setUpResourcesOnThisThread(testContext);
        this.oneHundredOneConstitutions = SwiftBlobIntegrationLiveTest.getTestDataSupplier();
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        super.checkContentDisposition(blob, contentDisposition);
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage() == null);
        assert (blob.getMetadata().getContentMetadata().getContentLanguage() == null);
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"{great<r}"}, {"lesst>en"}, {"p|pe"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMultipartChunkedFileStream() throws IOException, InterruptedException {
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            long countBefore = blobStore.countBlobs(containerName);
            this.addMultipartBlobToContainer(containerName, "const.txt");
            long countAfter = blobStore.countBlobs(containerName);
            Assert.assertNotEquals((Object)countBefore, (Object)countAfter, (String)"No blob was created");
            Assert.assertTrue((countAfter - countBefore > 1L ? 1 : 0) != 0, (String)"A multipart blob wasn't actually created - there was only 1 extra blob but there should be one manifest blob and multiple chunk blobs");
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void addMultipartBlobToContainer(String containerName, String key) throws IOException {
        File fileToUpload = this.createFileBiggerThan(0x500000L);
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        blobStore.createContainerInLocation(null, containerName);
        Blob blob = blobStore.blobBuilder(key).payload(fileToUpload).build();
        blobStore.putBlob(containerName, blob, PutOptions.Builder.multipart());
    }

    private File createFileBiggerThan(long partSize) throws IOException {
        long copiesNeeded = partSize / SwiftBlobIntegrationLiveTest.getOneHundredOneConstitutionsLength() + 1L;
        InputSupplier temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{this.oneHundredOneConstitutions});
        int i = 0;
        while ((long)i < copiesNeeded) {
            temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{temp, this.oneHundredOneConstitutions});
            ++i;
        }
        File fileToUpload = new File("target/lots-of-const.txt");
        Files.copy((InputSupplier)temp, (File)fileToUpload);
        Assert.assertTrue((fileToUpload.length() > partSize ? 1 : 0) != 0);
        return fileToUpload;
    }

    protected int getIncorrectContentMD5StatusCode() {
        return 422;
    }
}

