/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ListContainerOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(ListContainerOptions.class));
        assert (!String.class.isAssignableFrom(ListContainerOptions.class));
    }

    @Test
    public void testPrefix() {
        ListContainerOptions options = new ListContainerOptions();
        options.withPrefix("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNoOptionsQueryString() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((int)options.buildQueryParameters().size(), (int)0);
    }

    @Test
    public void testOneOptionQueryString() {
        ListContainerOptions options = new ListContainerOptions();
        options.withPrefix("test");
        Multimap map = options.buildQueryParameters();
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertEquals((Collection)map.get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testTwoOptionQueryString() {
        ListContainerOptions options = new ListContainerOptions();
        options.withPrefix("test").maxResults(1);
        Multimap map = options.buildQueryParameters();
        Assert.assertEquals((int)map.size(), (int)2);
        Assert.assertEquals((Collection)map.get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)map.get((Object)"limit"), (Collection)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testPrefixAndPathUrlEncodingQueryString() {
        ListContainerOptions options = new ListContainerOptions();
        options.withPrefix("/cloudfiles/test").underPath("/");
        Multimap map = options.buildQueryParameters();
        Assert.assertEquals((int)map.size(), (int)2);
        Assert.assertEquals((Collection)map.get((Object)"prefix"), (Collection)ImmutableList.of((Object)"/cloudfiles/test"));
        Assert.assertEquals((Collection)map.get((Object)"path"), (Collection)ImmutableList.of((Object)"/"));
    }

    @Test
    public void testNullPrefix() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"prefix"), (Collection)ImmutableList.of());
    }

    @Test
    public void testPrefixStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.withPrefix((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPrefixNPE() {
        ListContainerOptions.Builder.withPrefix(null);
    }

    @Test
    public void testMarker() {
        ListContainerOptions options = new ListContainerOptions();
        options.afterMarker("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"marker"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullMarker() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"marker"), (Collection)ImmutableList.of());
    }

    @Test
    public void testMarkerStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.afterMarker((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"marker"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testMarkerNPE() {
        ListContainerOptions.Builder.afterMarker(null);
    }

    @Test
    public void testMaxKeys() {
        ListContainerOptions options = new ListContainerOptions();
        options.maxResults(1000);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"limit"), (Collection)ImmutableList.of((Object)"1000"));
    }

    @Test
    public void testNullMaxKeys() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"limit"), (Collection)ImmutableList.of());
    }

    @Test
    public void testMaxKeysStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.maxResults((int)1000);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"limit"), (Collection)ImmutableList.of((Object)"1000"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMaxKeysNegative() {
        ListContainerOptions.Builder.maxResults((int)-1);
    }

    @Test
    public void testPath() {
        ListContainerOptions options = new ListContainerOptions();
        options.underPath("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"path"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullPath() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"path"), (Collection)ImmutableList.of());
    }

    @Test
    public void testPathStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.underPath((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"path"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPathNPE() {
        ListContainerOptions.Builder.underPath(null);
    }
}

