/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.VCloudVersionsAsyncClient;
import org.jclouds.vcloud.VCloudVersionsClient;
import org.jclouds.vcloud.xml.SupportedVersionsHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VCloudVersionsAsyncClientTest")
public class VCloudVersionsAsyncClientTest
extends BaseAsyncClientTest<VCloudVersionsAsyncClient> {
    public void testVersions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VCloudVersionsAsyncClient.class, (String)"getSupportedVersions", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://localhost:8080/versions HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, SupportedVersionsHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    protected ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(VCloudVersionsClient.class, VCloudVersionsAsyncClient.class, (String)"http://localhost:8080");
    }
}

