/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.internal.OrgImpl;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.OrgHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class OrgHandlerTest {
    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/org-1.0.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        Org result = (Org)factory.create((ParseSax.HandlerWithResult)injector.getInstance(OrgHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"ExampleOrg");
        Assert.assertEquals((String)result.getFullName(), (String)"ExampleOrg");
        Assert.assertEquals((String)result.getDescription(), (String)"Example Corp's Primary Organization.");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("http://vcloud.example.com/api/v1.0/org/5"));
        Assert.assertEquals((Map)result.getCatalogs(), (Map)ImmutableMap.of((Object)"Main Catalog", (Object)new ReferenceTypeImpl("Main Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("http://vcloud.example.com/api/v1.0/catalog/32")), (Object)"Shared Catalog", (Object)new ReferenceTypeImpl("Shared Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("http://vcloud.example.com/api/v1.0/catalog/37"))));
        Assert.assertEquals((Map)result.getVDCs(), (Map)ImmutableMap.of((Object)"ExampleVdc01", (Object)new ReferenceTypeImpl("ExampleVdc01", "application/vnd.vmware.vcloud.vdc+xml", URI.create("http://vcloud.example.com/api/v1.0/vdc/5"))));
        Assert.assertEquals((Map)result.getNetworks(), (Map)ImmutableMap.of((Object)"TestNetwork", (Object)new ReferenceTypeImpl("TestNetwork", "application/vnd.vmware.vcloud.network+xml", URI.create("http://vcloud.example.com/api/v1.0/network/14")), (Object)"ProductionNetwork", (Object)new ReferenceTypeImpl("ProductionNetwork", "application/vnd.vmware.vcloud.network+xml", URI.create("http://vcloud.example.com/api/v1.0/network/54"))));
        Assert.assertEquals((Object)result.getTasksList(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.tasksList+xml", URI.create("http://vcloud.example.com/api/v1.0/tasksList/5")));
    }

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/org.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        Org result = (Org)factory.create((ParseSax.HandlerWithResult)injector.getInstance(OrgHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"adrian@jclouds.org");
        Assert.assertEquals((String)result.getFullName(), (String)"adrian@jclouds.org");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"));
        Assert.assertEquals((Map)result.getCatalogs(), (Map)ImmutableMap.of((Object)"Miami Environment 1 Catalog", (Object)new ReferenceTypeImpl("Miami Environment 1 Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32/catalog"))));
        Assert.assertEquals((Map)result.getVDCs(), (Map)ImmutableMap.of((Object)"Miami Environment 1", (Object)new ReferenceTypeImpl("Miami Environment 1", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32"))));
        Assert.assertEquals((Object)result.getTasksList(), (Object)new ReferenceTypeImpl("Miami Environment 1 Tasks List", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/tasksList/32")));
    }

    public void testHosting() {
        InputStream is = this.getClass().getResourceAsStream("/org-hosting.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        Org result = (Org)factory.create((ParseSax.HandlerWithResult)injector.getInstance(OrgHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Customer 188849");
        Assert.assertEquals((String)result.getFullName(), (String)"Customer 188849");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/188849"));
        Assert.assertEquals((Map)result.getCatalogs(), (Map)ImmutableMap.of((Object)"HMS Shared Catalog", (Object)new ReferenceTypeImpl("HMS Shared Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1"))));
        Assert.assertEquals((Map)result.getVDCs(), (Map)ImmutableMap.of((Object)"188849 Virtual DataCenter", (Object)new ReferenceTypeImpl("188849 Virtual DataCenter", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/188849"))));
        Assert.assertEquals((Object)result.getTasksList(), (Object)new ReferenceTypeImpl("188849 Task List", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/188849")));
    }

    public void testSavvis() {
        InputStream is = this.getClass().getResourceAsStream("/org-savvis.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        Org result = (Org)factory.create((ParseSax.HandlerWithResult)injector.getInstance(OrgHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new OrgImpl("607968.0", null, null, "607968.0", "Gravitant Inc", (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"GravDataCenter1(Saved)", (Object)new ReferenceTypeImpl("GravDataCenter1(Saved)", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://api.symphonyVPDC.savvis.net/rest/api/v0.8/org/607968.0/vdc/2826"))), (Map)ImmutableMap.of(), null, (Iterable)ImmutableSet.of()));
    }
}

