/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.VDC;

@Singleton
public class OrgNameAndVDCNameToEndpoint
implements MapBinder {
    private final Supplier<Map<String, Org>> orgNameToVDCEndpoint;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultVDC;

    @Inject
    public OrgNameAndVDCNameToEndpoint(Supplier<Map<String, Org>> orgNameToVDCEndpoint, @org.jclouds.vcloud.endpoints.Org Supplier<ReferenceType> defaultOrg, @VDC Supplier<ReferenceType> defaultVDC) {
        this.orgNameToVDCEndpoint = orgNameToVDCEndpoint;
        this.defaultOrg = defaultOrg;
        this.defaultVDC = defaultVDC;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Object org = postParams.get("orgName");
        Object vdc = postParams.get("vdcName");
        if (org == null && vdc == null) {
            return (R)request.toBuilder().endpoint(((ReferenceType)this.defaultVDC.get()).getHref()).build();
        }
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        try {
            Map<String, ReferenceType> vdcs = ((Org)Preconditions.checkNotNull(((Map)this.orgNameToVDCEndpoint.get()).get(org))).getVDCs();
            URI endpoint = vdc == null ? ((ReferenceType)Iterables.getLast(vdcs.values())).getHref() : vdcs.get(vdc).getHref();
            return (R)request.toBuilder().endpoint(endpoint).build();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + vdc + " not found in " + this.orgNameToVDCEndpoint.get());
        }
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException(this.getClass() + " needs parameters");
    }
}

