/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.endpoints.Org;

public abstract class OrgNameVDCNameResourceNameToEndpoint
implements MapBinder {
    protected final Supplier<Map<String, Map<String, VDC>>> orgVDCMap;
    protected final Supplier<ReferenceType> defaultOrg;
    protected final Supplier<ReferenceType> defaultVDC;

    @Inject
    public OrgNameVDCNameResourceNameToEndpoint(Supplier<Map<String, Map<String, VDC>>> orgVDCMap, @Org Supplier<ReferenceType> defaultOrg, @org.jclouds.vcloud.endpoints.VDC Supplier<ReferenceType> defaultVDC) {
        this.orgVDCMap = orgVDCMap;
        this.defaultOrg = defaultOrg;
        this.defaultVDC = defaultVDC;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Map orgToVDCs;
        Object org = postParams.get("orgName");
        Object vDC = postParams.get("vdcName");
        Object resource = postParams.get("resourceName");
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        if (vDC == null) {
            vDC = ((ReferenceType)this.defaultVDC.get()).getName();
        }
        Preconditions.checkState(((orgToVDCs = (Map)this.orgVDCMap.get()) != null ? 1 : 0) != 0, (Object)"could not get map of org name to vdcs!");
        Map vDCs = (Map)orgToVDCs.get(org);
        if (vDCs == null) {
            throw new NoSuchElementException("org " + org + " not found in " + orgToVDCs.keySet());
        }
        VDC vDCObject = (VDC)vDCs.get(vDC);
        if (vDCObject == null) {
            throw new NoSuchElementException("vdc " + vDC + " in org " + org + " not found in " + vDCs.keySet());
        }
        URI endpoint = this.getEndpointOfResourceInVDC(org, vDC, resource, vDCObject);
        return (R)request.toBuilder().endpoint(endpoint).build();
    }

    protected abstract URI getEndpointOfResourceInVDC(Object var1, Object var2, Object var3, VDC var4);

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException(this.getClass() + " needs parameters");
    }
}

