/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.ReferenceType;

public class NetworkConnectionSection {
    protected final String type;
    protected final URI href;
    protected final String info;
    protected final Integer primaryNetworkConnectionIndex;
    protected final Set<NetworkConnection> connections;
    protected final ReferenceType edit;

    public static Builder builder() {
        return new Builder();
    }

    public NetworkConnectionSection(String type, URI href, String info, Integer primaryNetworkConnectionIndex, Iterable<NetworkConnection> connections, ReferenceType edit) {
        this.type = type;
        this.href = href;
        this.info = info;
        this.primaryNetworkConnectionIndex = primaryNetworkConnectionIndex;
        this.connections = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(connections, (Object)"connections")));
        this.edit = edit;
    }

    public String getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    public String getInfo() {
        return this.info;
    }

    public Integer getPrimaryNetworkConnectionIndex() {
        return this.primaryNetworkConnectionIndex;
    }

    public Set<NetworkConnection> getConnections() {
        return this.connections;
    }

    public ReferenceType getEdit() {
        return this.edit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connections == null ? 0 : this.connections.hashCode());
        result = 31 * result + (this.edit == null ? 0 : this.edit.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.primaryNetworkConnectionIndex == null ? 0 : this.primaryNetworkConnectionIndex.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkConnectionSection other = (NetworkConnectionSection)obj;
        if (this.connections == null ? other.connections != null : !this.connections.equals(other.connections)) {
            return false;
        }
        if (this.edit == null ? other.edit != null : !this.edit.equals(other.edit)) {
            return false;
        }
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.primaryNetworkConnectionIndex == null ? other.primaryNetworkConnectionIndex != null : !this.primaryNetworkConnectionIndex.equals(other.primaryNetworkConnectionIndex)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public Builder toBuilder() {
        return Builder.fromNetworkConnectionSection(this);
    }

    public String toString() {
        return "[href=" + this.href + ", connections=" + this.connections + ", primaryNetworkConnectionIndex=" + this.primaryNetworkConnectionIndex + "]";
    }

    public static class Builder {
        protected String type;
        protected URI href;
        protected String info;
        protected Integer primaryNetworkConnectionIndex;
        protected Set<NetworkConnection> connections = ImmutableSet.of();
        protected ReferenceType edit;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public Builder info(String info) {
            this.info = info;
            return this;
        }

        public Builder primaryNetworkConnectionIndex(Integer primaryNetworkConnectionIndex) {
            this.primaryNetworkConnectionIndex = primaryNetworkConnectionIndex;
            return this;
        }

        public Builder connections(Iterable<NetworkConnection> connections) {
            this.connections = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(connections, (Object)"connections")));
            return this;
        }

        public Builder edit(ReferenceType edit) {
            this.edit = edit;
            return this;
        }

        public NetworkConnectionSection build() {
            return new NetworkConnectionSection(this.type, this.href, this.info, this.primaryNetworkConnectionIndex, this.connections, this.edit);
        }

        public static Builder fromNetworkConnectionSection(NetworkConnectionSection in) {
            return new Builder().type(in.getType()).href(in.getHref()).info(in.getInfo()).primaryNetworkConnectionIndex(in.getPrimaryNetworkConnectionIndex()).connections(in.getConnections()).edit(in.getEdit());
        }
    }
}

