/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class VAppTemplatesForCatalogItems
implements Function<Iterable<CatalogItem>, Iterable<VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    VAppTemplatesForCatalogItems(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<VAppTemplate> apply(Iterable<CatalogItem> from) {
        return Iterables.filter((Iterable)FutureIterables.transformParallel((Iterable)Iterables.filter(from, (Predicate)new Predicate<CatalogItem>(){

            public boolean apply(CatalogItem input) {
                return input.getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml");
            }
        }), (Function)new Function<CatalogItem, ListenableFuture<? extends VAppTemplate>>(){

            public ListenableFuture<VAppTemplate> apply(CatalogItem from) {
                return VAppTemplatesForCatalogItems.this.aclient.getVAppTemplateClient().getVAppTemplate(from.getEntity().getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"vappTemplates in"), (Predicate)Predicates.notNull());
    }
}

