/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.openstack.functions.ParseAuthenticationResponseFromHeaders;
import org.jclouds.openstack.internal.OpenStackAuthAsyncClient;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.AnonymousRestApiMetadata;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OpenStackAuthAsyncClientTest")
public class OpenStackAuthAsyncClientTest
extends BaseAsyncClientTest<OpenStackAuthAsyncClient> {
    public void testAuthenticate() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(OpenStackAuthAsyncClient.class, (String)"authenticate", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"foo", (Object)"bar"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/v1.0 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: */*\nHost: localhost:8080\nX-Auth-Key: bar\nX-Auth-User: foo\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseAuthenticationResponseFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
    }

    public void testAuthenticateStorage() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(OpenStackAuthAsyncClient.class, (String)"authenticateStorage", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"foo", (Object)"bar"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET http://localhost:8080/v1.0 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: */*\nHost: localhost:8080\nX-Storage-Pass: bar\nX-Storage-User: foo\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseAuthenticationResponseFromHeaders.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
    }

    public ApiMetadata createApiMetadata() {
        return ((AnonymousRestApiMetadata.Builder)((AnonymousRestApiMetadata.Builder)AnonymousRestApiMetadata.forClientMappedToAsyncClient(IntegrationTestClient.class, IntegrationTestAsyncClient.class).toBuilder().defaultEndpoint("http://localhost:8080")).version("1.0")).build();
    }

    protected void checkFilters(HttpRequest request) {
    }
}

