/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.domain.AuthenticationResponse;

public class TestOpenStackAuthenticationModule
extends OpenStackAuthenticationModule {
    protected void configure() {
        super.configure();
        this.bind(OpenStackAuthenticationModule.GetAuthenticationResponse.class).to(TestGetAuthenticationResponse.class);
    }

    public Supplier<String> provideAuthenticationTokenCache(Supplier<AuthenticationResponse> supplier) {
        return new Supplier<String>(){

            public String get() {
                return "testtoken";
            }
        };
    }

    public Supplier<Date> provideCacheBusterDate() {
        return new Supplier<Date>(){

            public Date get() {
                return new Date();
            }
        };
    }

    @Singleton
    public static class TestGetAuthenticationResponse
    extends OpenStackAuthenticationModule.GetAuthenticationResponse {
        @Inject
        protected TestGetAuthenticationResponse() {
            super(null);
        }

        public AuthenticationResponse load(Credentials input) {
            return new AuthenticationResponse("authToken", (Map)ImmutableMap.of((Object)"X-Server-Management-Url", (Object)URI.create("http://endpoint/vapi-version"), (Object)"X-Storage-Url", (Object)URI.create("http://storage")));
        }
    }
}

