/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.parse.ParseAuthTest;
import org.jclouds.openstack.keystone.v1_1.suppliers.RegionIdToURIFromAuthForServiceSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionIdToURIFromAuthForServiceSupplierTest")
public class RegionIdToURIFromAuthForServiceSupplierTest {
    private final RegionIdToURISupplier.Factory factory = (RegionIdToURISupplier.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("keystone");
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAuthForServiceSupplier.class).build(RegionIdToURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Auth> provide() {
            return Suppliers.ofInstance((Object)new ParseAuthTest().expected());
        }
    }}).getInstance(RegionIdToURISupplier.Factory.class);

    public void testRegionMatches() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.factory.createForApiTypeAndVersion("cloudFilesCDN", "1.0").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"LON", (Object)URI.create("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953")));
    }

    public void testTakesFirstPartOfDNSWhenNoRegion() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.factory.createForApiTypeAndVersion("cloudServers", "1.1").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"lon", (Object)URI.create("https://lon.servers.api.rackspacecloud.com/v1.0/10001786")));
    }
}

