/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.openstack.options.BaseListOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BaseListOptionsTest {
    public void testChangesSince() {
        Date ifModifiedSince = new Date();
        BaseListOptions options = new BaseListOptions().changesSince(ifModifiedSince);
        Assert.assertEquals((Collection)ImmutableList.of((Object)(ifModifiedSince.getTime() / 1000L + "")), (Collection)options.buildQueryParameters().get((Object)"changes-since"));
    }

    public void testStartAt() {
        long offset = 1L;
        BaseListOptions options = new BaseListOptions().startAt(offset);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"offset"));
    }

    public void testMaxResults() {
        int limit = 1;
        BaseListOptions options = new BaseListOptions().maxResults(limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }

    public void testChangesSinceStatic() {
        Date ifModifiedSince = new Date();
        BaseListOptions options = BaseListOptions.Builder.changesSince((Date)ifModifiedSince);
        Assert.assertEquals((Collection)ImmutableList.of((Object)(ifModifiedSince.getTime() / 1000L + "")), (Collection)options.buildQueryParameters().get((Object)"changes-since"));
    }

    public void testStartAtStatic() {
        long offset = 1L;
        BaseListOptions options = BaseListOptions.Builder.startAt((long)offset);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"offset"));
    }

    public void testMaxResultsStatic() {
        int limit = 1;
        BaseListOptions options = BaseListOptions.Builder.maxResults((int)limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }
}

