/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.openstack.keystone.v1_1.domain.Endpoint;
import org.jclouds.openstack.keystone.v1_1.domain.Token;

public class Auth
implements Comparable<Auth> {
    protected final Token token;
    protected final Multimap<String, Endpoint> serviceCatalog;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Auth.builder().fromAccess(this);
    }

    public Auth(Token token, Multimap<String, Endpoint> serviceCatalog) {
        this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token");
        this.serviceCatalog = ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(serviceCatalog, (Object)"serviceCatalog")));
    }

    public Token getToken() {
        return this.token;
    }

    public Multimap<String, Endpoint> getServiceCatalog() {
        return this.serviceCatalog;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Auth) {
            Auth other = (Auth)Auth.class.cast(object);
            return Objects.equal((Object)this.token, (Object)other.token) && Objects.equal(this.serviceCatalog, other.serviceCatalog);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.token, this.serviceCatalog});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("token", (Object)this.token).add("serviceCatalog", this.serviceCatalog).toString();
    }

    @Override
    public int compareTo(Auth that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.token.compareTo(that.token);
    }

    public static class Builder {
        protected Token token;
        protected Multimap<String, Endpoint> serviceCatalog = ImmutableMultimap.of();

        public Builder token(Token token) {
            this.token = (Token)Preconditions.checkNotNull((Object)token, (Object)"token");
            return this;
        }

        public Builder serviceCatalog(Multimap<String, Endpoint> serviceCatalog) {
            this.serviceCatalog = ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(serviceCatalog, (Object)"serviceCatalog")));
            return this;
        }

        public Auth build() {
            return new Auth(this.token, this.serviceCatalog);
        }

        public Builder fromAccess(Auth from) {
            return this.token(from.getToken()).serviceCatalog(from.getServiceCatalog());
        }
    }
}

