/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.functions.EndpointToRegion;
import org.jclouds.openstack.keystone.v1_1.functions.EndpointToSupplierURI;

@Singleton
public class RegionIdToURIFromAuthForServiceSupplier
implements RegionIdToURISupplier {
    private final Supplier<Auth> auth;
    private final EndpointToSupplierURI endpointToSupplierURI;
    private final EndpointToRegion endpointToRegion;
    private final String apiType;

    @Inject
    public RegionIdToURIFromAuthForServiceSupplier(Supplier<Auth> auth, EndpointToSupplierURI endpointToSupplierURI, EndpointToRegion endpointToRegion, @Assisted(value="apiType") String apiType, @Nullable @Assisted(value="apiVersion") String apiVersion) {
        this.auth = auth;
        this.endpointToSupplierURI = endpointToSupplierURI;
        this.endpointToRegion = endpointToRegion;
        this.apiType = apiType;
    }

    public Map<String, Supplier<URI>> get() {
        Auth authResponse = (Auth)this.auth.get();
        Collection endpointsForService = authResponse.getServiceCatalog().get((Object)this.apiType);
        ImmutableMap regionIdToEndpoint = Maps.uniqueIndex((Iterable)endpointsForService, (Function)this.endpointToRegion);
        return Maps.transformValues((Map)regionIdToEndpoint, (Function)this.endpointToSupplierURI);
    }

    public String toString() {
        return "getPublicURLForService(" + this.apiType + ")";
    }
}

