/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.cim.CIMPredicates;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.CustomizationParameters;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;
import org.jclouds.trmk.vcloud_0_8.domain.Network;
import org.jclouds.trmk.vcloud_0_8.domain.Node;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.TasksList;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.VAppConfiguration;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.options.AddInternetServiceOptions;
import org.jclouds.trmk.vcloud_0_8.options.AddNodeOptions;
import org.jclouds.trmk.vcloud_0_8.options.CloneVAppOptions;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.predicates.TaskSuccess;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public abstract class TerremarkClientLiveTest
extends BaseApiLiveTest<TerremarkVCloudClient> {
    protected String expectedOs = "Ubuntu Linux (64-bit)";
    protected String itemName = "Ubuntu JeOS 9.10 (64-bit)";
    protected SshClient.Factory sshFactory;
    protected String publicIp;
    protected InternetService is;
    protected Node node;
    protected VApp vApp;
    protected Predicate<HostAndPort> socketTester;
    protected Predicate<URI> successTester;
    protected Injector injector;
    protected VApp clone;
    protected VDC vdc;
    protected String serverName;
    protected KeyPair key;
    public static final String PREFIX = System.getProperty("user.name") + "-terremark";
    protected Iterable<Org> orgs;

    public TerremarkClientLiveTest() {
        this.provider = "trmk-vcloudexpress";
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            name.append("d");
        }
        this.serverName = name.toString();
    }

    @Test
    public void testKeysList() throws Exception {
        for (Org org : this.orgs) {
            TerremarkVCloudClient vCloudExpressClient = (TerremarkVCloudClient)TerremarkVCloudClient.class.cast(this.api);
            Set response = vCloudExpressClient.listKeyPairsInOrg(org.getHref());
            Assert.assertNotNull((Object)response);
        }
    }

    @Test
    public void testGetAllInternetServices() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                for (InternetService service : ((TerremarkVCloudClient)this.api).getAllInternetServicesInVDC(vdc.getHref())) {
                    Assert.assertNotNull((Object)((TerremarkVCloudClient)this.api).getNodes(service.getId()));
                }
            }
        }
    }

    @Test
    public void testCreateInternetServiceMonitorDisabled() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                Set publicIpAddresses = ((TerremarkVCloudClient)this.api).getPublicIpsAssociatedWithVDC(vdc.getHref());
                PublicIpAddress publicIp = (PublicIpAddress)publicIpAddresses.iterator().next();
                InternetService service = ((TerremarkVCloudClient)this.api).addInternetServiceToExistingIp(publicIp.getId(), PREFIX + "-no-monitoring", Protocol.TCP, 1234, new AddInternetServiceOptions[]{AddInternetServiceOptions.Builder.monitorDisabled()});
                ((TerremarkVCloudClient)this.api).deleteInternetService(service.getId());
            }
        }
    }

    @Test
    public void testGetPublicIpsAssociatedWithVDC() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                for (PublicIpAddress ip : ((TerremarkVCloudClient)this.api).getPublicIpsAssociatedWithVDC(vdc.getHref())) {
                    Assert.assertNotNull((Object)((TerremarkVCloudClient)this.api).getInternetServicesOnPublicIp(ip.getId()));
                    Assert.assertNotNull((Object)((TerremarkVCloudClient)this.api).getPublicIp(ip.getId()));
                }
            }
        }
    }

    @Test
    public void testGetConfigCustomizationOptions() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType catalog : org.getCatalogs().values()) {
                Catalog response = ((TerremarkVCloudClient)this.api).getCatalog(catalog.getHref());
                for (ReferenceType resource : response.values()) {
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml")) continue;
                    CatalogItem item = ((TerremarkVCloudClient)this.api).findCatalogItemInOrgCatalogNamed(org.getName(), catalog.getName(), resource.getName());
                    assert (((TerremarkVCloudClient)this.api).getCustomizationOptions(item.getCustomizationOptions().getHref()) != null);
                }
            }
        }
    }

    @Test(enabled=true)
    public void testInstantiateAndPowerOn() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.prepare();
        long hardDisk = 0x400000L;
        this.vdc = ((TerremarkVCloudClient)this.api).findVDCInOrgNamed(null, null);
        InstantiateVAppTemplateOptions instantiateOptions = this.createInstantiateOptions().sshKeyFingerprint(this.key.getFingerPrint());
        CatalogItem item = ((TerremarkVCloudClient)this.api).findCatalogItemInOrgCatalogNamed(null, null, this.itemName);
        assert (item != null);
        CustomizationParameters customizationOptions = ((TerremarkVCloudClient)this.api).getCustomizationOptions(item.getCustomizationOptions().getHref());
        if (customizationOptions.canCustomizePassword()) {
            instantiateOptions.withPassword("robotsarefun");
        }
        VAppTemplate vAppTemplate = ((TerremarkVCloudClient)this.api).getVAppTemplate(item.getEntity().getHref());
        assert (vAppTemplate != null);
        this.vApp = ((TerremarkVCloudClient)this.api).instantiateVAppTemplateInVDC(this.vdc.getHref(), vAppTemplate.getHref(), this.serverName, new InstantiateVAppTemplateOptions[]{instantiateOptions});
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.RESOLVED);
        Task deployTask = ((TerremarkVCloudClient)this.api).deployVApp(this.vApp.getHref());
        deployTask = ((TerremarkVCloudClient)this.api).deployVApp(this.vApp.getHref());
        Assert.assertEquals((Object)deployTask.getHref(), (Object)deployTask.getHref());
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.RESOLVED);
        try {
            ((TerremarkVCloudClient)this.api).cancelTask(deployTask.getHref());
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        assert (this.successTester.apply((Object)deployTask.getHref()));
        System.out.printf("%d: done deploying vApp%n", System.currentTimeMillis());
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        ReferenceType vAppResource = (ReferenceType)((TerremarkVCloudClient)this.api).findVDCInOrgNamed(null, null).getResourceEntities().get(this.serverName);
        Assert.assertEquals((Object)vAppResource.getHref(), (Object)this.vApp.getHref());
        int processorCount = 1;
        long memory = 512L;
        this.verifyConfigurationOfVApp(this.vApp, this.serverName, this.expectedOs, processorCount, memory, hardDisk);
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.OFF);
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOnVApp(this.vApp.getHref()).getHref()));
        System.out.printf("%d: done powering on vApp%n", System.currentTimeMillis());
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.ON);
    }

    protected InstantiateVAppTemplateOptions createInstantiateOptions() {
        return InstantiateVAppTemplateOptions.Builder.processorCount((int)1).memory(512L).sshKeyFingerprint(this.key.getFingerPrint());
    }

    protected void prepare() {
        Org org = ((TerremarkVCloudClient)this.api).findOrgNamed(null);
        try {
            this.key = ((TerremarkVCloudClient)this.api).generateKeyPairInOrg(org.getHref(), "livetest", false);
        }
        catch (IllegalStateException e) {
            this.key = ((TerremarkVCloudClient)this.api).findKeyPairInOrg(org.getHref(), "livetest");
            ((TerremarkVCloudClient)this.api).deleteKeyPair(this.key.getId());
            this.key = ((TerremarkVCloudClient)this.api).generateKeyPairInOrg(org.getHref(), "livetest", false);
        }
        Assert.assertNotNull((Object)this.key);
        Assert.assertEquals((String)this.key.getName(), (String)"livetest");
        Assert.assertNotNull((Object)this.key.getPrivateKey());
        Assert.assertNotNull((Object)this.key.getFingerPrint());
        Assert.assertEquals((boolean)this.key.isDefault(), (boolean)false);
        Assert.assertEquals((String)this.key.getFingerPrint(), (String)((TerremarkVCloudClient)this.api).findKeyPairInOrg(org.getHref(), this.key.getName()).getFingerPrint());
    }

    protected abstract Map.Entry<InternetService, PublicIpAddress> getNewInternetServiceAndIpForSSH(VApp var1);

    @Test(enabled=true, dependsOnMethods={"testInstantiateAndPowerOn"})
    public void testAddInternetService() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        Map.Entry<InternetService, PublicIpAddress> entry = this.getNewInternetServiceAndIpForSSH(this.vApp);
        this.is = entry.getKey();
        this.publicIp = entry.getValue().getAddress();
    }

    @Test(enabled=true, dependsOnMethods={"testInstantiateAndPowerOn"})
    public void testCloneVApp() throws IOException {
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOffVApp(this.vApp.getHref()).getHref()));
        System.out.printf("%d: done powering off vApp%n", System.currentTimeMillis());
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            name.append("b");
        }
        String newName = name.toString();
        CloneVAppOptions options = CloneVAppOptions.Builder.deploy().powerOn().withDescription("The description of " + newName);
        System.out.printf("%d: cloning vApp%n", System.currentTimeMillis());
        Task task = ((TerremarkVCloudClient)this.api).cloneVAppInVDC(this.vdc.getHref(), this.vApp.getHref(), newName, new CloneVAppOptions[]{options});
        assert (this.successTester.apply((Object)task.getHref()));
        System.out.printf("%d: done cloning vApp%n", System.currentTimeMillis());
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOnVApp(this.vApp.getHref()).getHref()));
        System.out.printf("%d: done powering on vApp%n", System.currentTimeMillis());
        task = ((TerremarkVCloudClient)this.api).getTask(task.getHref());
        this.clone = ((TerremarkVCloudClient)this.api).getVApp(task.getOwner().getHref());
        Assert.assertEquals((Object)this.clone.getStatus(), (Object)Status.ON);
        Assert.assertEquals((String)this.clone.getName(), (String)newName);
        Assert.assertEquals((int)this.clone.getNetworkToAddresses().values().size(), (int)1);
    }

    @Test(enabled=true, dependsOnMethods={"testInstantiateAndPowerOn", "testAddInternetService"})
    public void testPublicIp() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.node = ((TerremarkVCloudClient)this.api).addNode(this.is.getId(), (String)Iterables.getLast((Iterable)this.vApp.getNetworkToAddresses().values()), this.vApp.getName() + "-SSH", 22, new AddNodeOptions[0]);
        this.loopAndCheckPass();
    }

    protected void loopAndCheckPass() throws IOException {
        for (int i = 0; i < 5; ++i) {
            try {
                this.doCheckPass(this.publicIp);
                return;
            }
            catch (SshException e) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    @Test(enabled=true, dependsOnMethods={"testPublicIp"})
    public void testConfigureNode() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        ((TerremarkVCloudClient)this.api).configureNode(this.node.getId(), this.node.getName(), this.node.isEnabled(), "holy cow");
    }

    @Test(enabled=true, dependsOnMethods={"testPublicIp"})
    public void testLifeCycle() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        try {
            ((TerremarkVCloudClient)this.api).undeployVApp(this.vApp.getHref());
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            ((TerremarkVCloudClient)this.api).suspendVApp(this.vApp.getHref());
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).resetVApp(this.vApp.getHref()).getHref()));
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.ON);
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOffVApp(this.vApp.getHref()).getHref()));
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        Assert.assertEquals((Object)this.vApp.getStatus(), (Object)Status.OFF);
    }

    @Test(enabled=true, dependsOnMethods={"testLifeCycle"})
    public void testConfigure() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        Task task = ((TerremarkVCloudClient)this.api).configureVApp(this.vApp, VAppConfiguration.Builder.changeNameTo((String)"eduardo").changeMemoryTo(1536L).changeProcessorCountTo(1).addDisk(0x1900000L).addDisk(0x1900000L));
        assert (this.successTester.apply((Object)task.getHref()));
        this.vApp = ((TerremarkVCloudClient)this.api).getVApp(this.vApp.getHref());
        Assert.assertEquals((String)this.vApp.getName(), (String)"eduardo");
        Assert.assertEquals((long)((ResourceAllocationSettingData)Iterables.find((Iterable)this.vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PROCESSOR}))).getVirtualQuantity(), (long)1L);
        Assert.assertEquals((long)((ResourceAllocationSettingData)Iterables.find((Iterable)this.vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.MEMORY}))).getVirtualQuantity(), (long)1536L);
        Assert.assertEquals((int)Iterables.size((Iterable)Iterables.filter((Iterable)this.vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE}))), (int)3);
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOnVApp(this.vApp.getHref()).getHref()));
        this.loopAndCheckPass();
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOffVApp(this.vApp.getHref()).getHref()));
        ArrayList disks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE})));
        task = ((TerremarkVCloudClient)this.api).configureVApp(this.vApp, VAppConfiguration.Builder.deleteDiskWithAddressOnParent((int)Integer.parseInt(((ResourceAllocationSettingData)disks.get(1)).getAddressOnParent())));
        assert (this.successTester.apply((Object)task.getHref()));
        assert (this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOnVApp(this.vApp.getHref()).getHref()));
        this.loopAndCheckPass();
    }

    protected void verifyConfigurationOfVApp(VApp vApp, String serverName, String expectedOs, int processorCount, long memory, long hardDisk) {
        Assert.assertEquals((String)vApp.getName(), (String)serverName);
        Assert.assertEquals((String)vApp.getOperatingSystemDescription(), (String)expectedOs);
        Assert.assertEquals((int)((int)((ResourceAllocationSettingData)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PROCESSOR}))).getVirtualQuantity().longValue()), (int)processorCount);
        Assert.assertEquals((long)((ResourceAllocationSettingData)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.MEMORY}))).getVirtualQuantity(), (long)memory);
        Assert.assertEquals((long)((ResourceAllocationSettingData)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE}))).getVirtualQuantity(), (long)hardDisk);
        Assert.assertEquals((long)vApp.getSize(), (long)((ResourceAllocationSettingData)Iterables.find((Iterable)vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE}))).getVirtualQuantity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCheckPass(String address) throws IOException {
        HostAndPort socket = HostAndPort.fromParts((String)address, (int)22);
        System.out.printf("%d: %s awaiting ssh service to start%n", System.currentTimeMillis(), socket);
        assert (this.socketTester.apply((Object)socket));
        System.out.printf("%d: %s ssh service started%n", System.currentTimeMillis(), socket);
        SshClient ssh = this.getConnectionFor(socket);
        try {
            ssh.connect();
            System.out.printf("%d: %s ssh ssh made%n", System.currentTimeMillis(), socket);
            System.out.println(ssh.exec("df -h"));
            System.out.println(ssh.exec("ls -al /dev/sd*"));
            System.out.println(ssh.exec("echo '$Ep455l0ud!2'|sudo -S fdisk -l"));
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    protected abstract SshClient getConnectionFor(HostAndPort var1);

    @AfterGroups(groups={"live"})
    void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.node != null) {
            ((TerremarkVCloudClient)this.api).deleteNode(this.node.getId());
        }
        if (this.is != null) {
            ((TerremarkVCloudClient)this.api).deleteInternetService(this.is.getId());
        }
        if (this.key != null) {
            ((TerremarkVCloudClient)this.api).deleteKeyPair(this.key.getId());
        }
        if (this.vApp != null) {
            try {
                this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOffVApp(this.vApp.getHref()).getHref());
            }
            catch (Exception e) {
                // empty catch block
            }
            ((TerremarkVCloudClient)this.api).deleteVApp(this.vApp.getHref());
        }
        if (this.clone != null) {
            try {
                this.successTester.apply((Object)((TerremarkVCloudClient)this.api).powerOffVApp(this.clone.getHref()).getHref());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((TerremarkVCloudClient)this.api).deleteVApp(this.clone.getHref());
        }
    }

    protected TerremarkVCloudClient create(Properties props, Iterable<Module> modules) {
        Injector injector = this.newBuilder().modules(modules).overrides(props).buildInjector();
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        this.socketTester = Predicates2.retry((Predicate)((Predicate)injector.getInstance(SocketOpen.class)), (long)300L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.successTester = Predicates2.retry((Predicate)((Predicate)injector.getInstance(TaskSuccess.class)), (long)650L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.api = (Closeable)injector.getInstance(TerremarkVCloudClient.class);
        this.orgs = this.listOrgs();
        return (TerremarkVCloudClient)this.api;
    }

    @Test
    public void testOrg() throws Exception {
        for (Org org : this.orgs) {
            Assert.assertNotNull((Object)org);
            Assert.assertNotNull((Object)org.getName());
            assert (org.getCatalogs().size() >= 1);
            assert (org.getTasksLists().size() >= 1);
            assert (org.getVDCs().size() >= 1);
            Assert.assertEquals((Object)((TerremarkVCloudClient)this.api).findOrgNamed(org.getName()), (Object)org);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesCanOverrideDefaultOrg() throws Exception {
        for (Org org : this.orgs) {
            TerremarkVCloudClient newApi = null;
            try {
                newApi = this.create(this.overrideDefaults((Map<String, String>)ImmutableMap.of((Object)"jclouds.vcloud.defaults.org", (Object)org.getName())), this.setupModules());
                Assert.assertEquals((Object)newApi.findOrgNamed(null), (Object)org);
            }
            finally {
                newApi.close();
            }
        }
    }

    public Properties overrideDefaults(Map<String, String> overrides) {
        Properties properties = this.setupProperties();
        properties.putAll(overrides);
        return properties;
    }

    @Test
    public void testCatalog() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType cat : org.getCatalogs().values()) {
                Catalog response = ((TerremarkVCloudClient)this.api).getCatalog(cat.getHref());
                Assert.assertNotNull((Object)response);
                Assert.assertNotNull((Object)response.getName());
                Assert.assertNotNull((Object)response.getHref());
                Assert.assertEquals((Map)((TerremarkVCloudClient)this.api).findCatalogInOrgNamed(org.getName(), response.getName()), (Map)response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesCanOverrideDefaultCatalog() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType cat : org.getCatalogs().values()) {
                TerremarkVCloudClient newApi = null;
                try {
                    newApi = this.create(this.overrideDefaults((Map<String, String>)ImmutableMap.of((Object)"jclouds.vcloud.defaults.org", (Object)org.getName(), (Object)"jclouds.vcloud.defaults.catalog", (Object)cat.getName())), this.setupModules());
                    Assert.assertEquals((Map)newApi.findCatalogInOrgNamed(null, null), (Map)((TerremarkVCloudClient)this.api).getCatalog(cat.getHref()));
                }
                finally {
                    newApi.close();
                }
            }
        }
    }

    @Test
    public void testGetVDCNetwork() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                VDC response = ((TerremarkVCloudClient)this.api).getVDC(vdc.getHref());
                for (ReferenceType resource : response.getAvailableNetworks().values()) {
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.network+xml")) continue;
                    try {
                        Network net = ((TerremarkVCloudClient)this.api).getNetwork(resource.getHref());
                        Assert.assertNotNull((Object)net);
                        Assert.assertNotNull((Object)net.getName());
                        Assert.assertNotNull((Object)net.getHref());
                        Assert.assertEquals((Object)((TerremarkVCloudClient)this.api).findNetworkInOrgVDCNamed(org.getName(), response.getName(), net.getName()), (Object)net);
                    }
                    catch (AuthorizationException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesCanOverrideDefaultNetwork() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                VDC response = ((TerremarkVCloudClient)this.api).getVDC(vdc.getHref());
                for (ReferenceType net : response.getAvailableNetworks().values()) {
                    TerremarkVCloudClient newApi = null;
                    try {
                        newApi = this.create(this.overrideDefaults((Map<String, String>)ImmutableMap.of((Object)"jclouds.vcloud.defaults.org", (Object)org.getName(), (Object)"jclouds.vcloud.defaults.vdc", (Object)vdc.getName(), (Object)"jclouds.vcloud.defaults.network", (Object)net.getName())), this.setupModules());
                        Assert.assertEquals((Object)newApi.findNetworkInOrgVDCNamed(null, null, net.getName()), (Object)((TerremarkVCloudClient)this.api).getNetwork(net.getHref()));
                    }
                    finally {
                        newApi.close();
                    }
                }
            }
        }
    }

    @Test
    public void testGetCatalogItem() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType cat : org.getCatalogs().values()) {
                Catalog response = ((TerremarkVCloudClient)this.api).getCatalog(cat.getHref());
                for (ReferenceType resource : response.values()) {
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml")) continue;
                    CatalogItem item = ((TerremarkVCloudClient)this.api).getCatalogItem(resource.getHref());
                    this.verifyCatalogItem(item);
                }
            }
        }
    }

    protected void verifyCatalogItem(CatalogItem item) {
        Assert.assertNotNull((Object)item);
        Assert.assertNotNull((Object)item);
        Assert.assertNotNull((Object)item.getEntity());
        Assert.assertNotNull((Object)item.getHref());
        Assert.assertNotNull((Object)item.getProperties());
        Assert.assertNotNull((Object)item.getType());
    }

    @Test
    public void testFindCatalogItem() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType cat : org.getCatalogs().values()) {
                Catalog response = ((TerremarkVCloudClient)this.api).getCatalog(cat.getHref());
                for (ReferenceType resource : response.values()) {
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml")) continue;
                    CatalogItem item = ((TerremarkVCloudClient)this.api).findCatalogItemInOrgCatalogNamed(org.getName(), response.getName(), resource.getName());
                    this.verifyCatalogItem(item);
                }
            }
        }
    }

    @Test
    public void testDefaultVDC() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                VDC response = ((TerremarkVCloudClient)this.api).getVDC(vdc.getHref());
                Assert.assertNotNull((Object)response);
                Assert.assertNotNull((Object)response.getName());
                Assert.assertNotNull((Object)response.getHref());
                Assert.assertNotNull((Object)response.getResourceEntities());
                Assert.assertNotNull((Object)response.getAvailableNetworks());
                Assert.assertNotNull((Object)response.getCatalog());
                Assert.assertNotNull((Object)response.getInternetServices());
                Assert.assertNotNull((Object)response.getPublicIps());
                Assert.assertEquals((Object)((TerremarkVCloudClient)this.api).getVDC(response.getHref()), (Object)response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesCanOverrideDefaultVDC() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                TerremarkVCloudClient newApi = null;
                try {
                    newApi = this.create(this.overrideDefaults((Map<String, String>)ImmutableMap.of((Object)"jclouds.vcloud.defaults.org", (Object)org.getName(), (Object)"jclouds.vcloud.defaults.vdc", (Object)vdc.getName())), this.setupModules());
                    Assert.assertEquals((Object)newApi.findVDCInOrgNamed(null, null), (Object)((TerremarkVCloudClient)this.api).getVDC(vdc.getHref()));
                }
                finally {
                    newApi.close();
                }
            }
        }
    }

    @Test
    public void testDefaultTasksList() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType tasksList : org.getTasksLists().values()) {
                TasksList response = ((TerremarkVCloudClient)this.api).findTasksListInOrgNamed(org.getName(), tasksList.getName());
                Assert.assertNotNull((Object)response);
                Assert.assertNotNull((Object)response.getLocation());
                Assert.assertNotNull((Object)response.getTasks());
                Assert.assertEquals((Object)((TerremarkVCloudClient)this.api).getTasksList(response.getLocation()).getLocation(), (Object)response.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertiesCanOverrideDefaultTasksList() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType tasksList : org.getTasksLists().values()) {
                TerremarkVCloudClient newApi = null;
                try {
                    newApi = this.create(this.overrideDefaults((Map<String, String>)ImmutableMap.of((Object)"jclouds.vcloud.defaults.org", (Object)org.getName(), (Object)"jclouds.vcloud.defaults.taskslist", (Object)tasksList.getName())), this.setupModules());
                    Assert.assertEquals((Object)newApi.findTasksListInOrgNamed(null, null), (Object)((TerremarkVCloudClient)this.api).getTasksList(tasksList.getHref()));
                }
                finally {
                    newApi.close();
                }
            }
        }
    }

    @Test
    public void testGetTask() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType tasksList : org.getTasksLists().values()) {
                TasksList response = ((TerremarkVCloudClient)this.api).findTasksListInOrgNamed(org.getName(), tasksList.getName());
                Assert.assertNotNull((Object)response);
                Assert.assertNotNull((Object)response.getLocation());
                Assert.assertNotNull((Object)response.getTasks());
                if (response.getTasks().size() <= 0) continue;
                Task task = (Task)response.getTasks().last();
                Assert.assertEquals((Object)((TerremarkVCloudClient)this.api).getTask(task.getHref()).getHref(), (Object)task.getHref());
            }
        }
    }

    protected Iterable<Org> listOrgs() {
        return Iterables.transform(((TerremarkVCloudClient)this.api).listOrgs().values(), (Function)new Function<ReferenceType, Org>(){

            public Org apply(ReferenceType arg0) {
                return ((TerremarkVCloudClient)TerremarkClientLiveTest.this.api).getOrg(arg0.getHref());
            }
        });
    }

    @Test
    public void testGetVAppTemplate() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType cat : org.getCatalogs().values()) {
                Catalog response = ((TerremarkVCloudClient)this.api).getCatalog(cat.getHref());
                for (ReferenceType resource : response.values()) {
                    CatalogItem item;
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = ((TerremarkVCloudClient)this.api).getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) continue;
                    Assert.assertNotNull((Object)((TerremarkVCloudClient)this.api).getVAppTemplate(item.getEntity().getHref()));
                }
            }
        }
    }

    @Test
    public void testGetVApp() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType vdc : org.getVDCs().values()) {
                VDC response = ((TerremarkVCloudClient)this.api).getVDC(vdc.getHref());
                for (ReferenceType item : response.getResourceEntities().values()) {
                    if (!item.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) continue;
                    try {
                        VApp app = ((TerremarkVCloudClient)this.api).getVApp(item.getHref());
                        Assert.assertNotNull((Object)app);
                    }
                    catch (RuntimeException e) {}
                }
            }
        }
    }

    @Test
    public void testFindVAppTemplate() throws Exception {
        for (Org org : this.orgs) {
            for (ReferenceType cat : org.getCatalogs().values()) {
                Catalog response = ((TerremarkVCloudClient)this.api).getCatalog(cat.getHref());
                for (ReferenceType resource : response.values()) {
                    CatalogItem item;
                    if (!resource.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml") || !(item = ((TerremarkVCloudClient)this.api).getCatalogItem(resource.getHref())).getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) continue;
                    Assert.assertNotNull((Object)((TerremarkVCloudClient)this.api).findVAppTemplateInOrgCatalogNamed(org.getName(), response.getName(), item.getEntity().getName()));
                }
            }
        }
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)new SshjSshClientModule());
    }
}

