/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindCloneVAppParamsToXmlPayload;
import org.jclouds.trmk.vcloud_0_8.internal.BasePayloadTest;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudApiMetadata;
import org.jclouds.trmk.vcloud_0_8.options.CloneVAppOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCloneVAppParamsToXmlPayloadTest
extends BasePayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            Properties props = TerremarkVCloudApiMetadata.defaultProperties();
            props.setProperty("jclouds.vcloud.xml.ns", "http://www.vmware.com/vcloud/v0.8");
            props.setProperty("jclouds.vcloud.xml.schema", "http://vcloud.safesecureweb.com/ns/vcloud.xsd");
            Names.bindProperties((Binder)this.binder(), (Properties)props);
        }
    }});

    public void testWithDescriptionDeployOn() throws Exception {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/cloneVApp.xml"));
        CloneVAppOptions options = new CloneVAppOptions().deploy().powerOn().withDescription("The description of the new vApp");
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("newName", "new-linux-server");
        map.put("vApp", "https://vcloud.safesecureweb.com/api/v0.8/vapp/201");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testDefault() throws Exception {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/cloneVApp-default.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of());
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("newName", "my-vapp");
        map.put("vApp", "https://vcloud.safesecureweb.com/api/v0.8/vapp/4181");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }
}

