/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindInstantiateVAppTemplateParamsToXmlPayload;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.internal.BasePayloadTest;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudApiMetadata;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.jclouds.util.Strings2;
import org.nnsoft.guice.rocoto.Rocoto;
import org.nnsoft.guice.rocoto.configuration.ConfigurationModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindInstantiateVAppTemplateParamsToXmlPayloadTest
extends BasePayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{Rocoto.expandVariables((Module[])new Module[]{new ConfigurationModule(){

        protected void bindConfigurations() {
            this.bindProperties(TerremarkVCloudApiMetadata.defaultProperties());
        }

        @Network
        @Provides
        @Singleton
        Supplier<ReferenceType> provideNetwork() {
            return Suppliers.ofInstance((Object)new ReferenceTypeImpl(null, null, URI.create("https://vcloud.safesecureweb.com/network/1990")));
        }
    }})});

    public void testAllOptions() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/InstantiateVAppTemplateParams-options-test.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)InstantiateVAppTemplateOptions.Builder.processorCount((int)2).memory(512L).inGroup("group").withPassword("password").inRow("row").addNetworkConfig(new InstantiateVAppTemplateOptions.NetworkConfig(URI.create("http://network")))));
        BindInstantiateVAppTemplateParamsToXmlPayload binder = (BindInstantiateVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindInstantiateVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "name");
        map.put("template", "https://vcloud/vAppTemplate/3");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }
}

