/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.easymock.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindNodeConfigurationToXmlPayload;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudApiMetadata;
import org.nnsoft.guice.rocoto.Rocoto;
import org.nnsoft.guice.rocoto.configuration.ConfigurationModule;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindNodeConfigurationToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{Rocoto.expandVariables((Module[])new Module[]{new ConfigurationModule(){

        protected void bindConfigurations() {
            Properties properties = TerremarkVCloudApiMetadata.defaultProperties();
            properties.setProperty("jclouds.api-version", "0.8a-ext1.6");
            properties.setProperty("jclouds.terremark.extension.name", "vCloudExpressExtensions");
            properties.setProperty("jclouds.terremark.extension.version", "1.6");
            properties.setProperty("jclouds.endpoint", "https://services.vcloudexpress.terremark.com/api");
            this.bindProperties(properties);
        }
    }})});

    public void testChangeDescription() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>true</Enabled><Description>description</Description></NodeService>";
        this.assertConfigMakesPayload((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"willie", (Object)"enabled", (Object)"true", (Object)"description", (Object)"description"), expectedPayload);
    }

    public void testDisableTraffic() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>false</Enabled></NodeService>";
        this.assertConfigMakesPayload((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"willie", (Object)"enabled", (Object)"false"), expectedPayload);
    }

    public void testTwoOptions() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>true</Enabled></NodeService>";
        this.assertConfigMakesPayload((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"willie", (Object)"enabled", (Object)"true"), expectedPayload);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNoOptions() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>false</Enabled></NodeService>";
        this.assertConfigMakesPayload((Map<String, Object>)ImmutableMap.of(), expectedPayload);
    }

    private void assertConfigMakesPayload(Map<String, Object> config, String expectedPayload) {
        BindNodeConfigurationToXmlPayload binder = (BindNodeConfigurationToXmlPayload)this.injector.getInstance(BindNodeConfigurationToXmlPayload.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        request.setPayload(expectedPayload);
        EasyMock.replay((Object[])new Object[]{request});
        binder.bindToRequest(request, config);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

