/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.easymock.EasyMock;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeClient;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.suppliers.InternetServiceAndPublicIpAddressSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class TerremarkVCloudComputeClientTest {
    @Test
    public void testStartWindows() throws IOException {
        HashMap credentialStore = Maps.newHashMap();
        InputStream is = this.getClass().getResourceAsStream("/windows_description.txt");
        String description = new String(ByteStreams.toByteArray((InputStream)is));
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        VDC vdc = (VDC)EasyMock.createMock(VDC.class);
        URI templateURI = URI.create("template");
        URI vdcURI = URI.create("vdc");
        EasyMock.expect((Object)template.getDescription()).andReturn((Object)description).atLeastOnce();
        TerremarkVCloudClient client = (TerremarkVCloudClient)EasyMock.createMock(TerremarkVCloudClient.class);
        VApp vApp = (VApp)EasyMock.createMock(VApp.class);
        InternetServiceAndPublicIpAddressSupplier supplier = (InternetServiceAndPublicIpAddressSupplier)EasyMock.createMock(InternetServiceAndPublicIpAddressSupplier.class);
        EasyMock.expect((Object)client.getVAppTemplate(templateURI)).andReturn((Object)template);
        EasyMock.expect((Object)client.instantiateVAppTemplateInVDC(vdcURI, templateURI, "name", new InstantiateVAppTemplateOptions[]{new InstantiateVAppTemplateOptions().productProperty("password", "password")})).andReturn((Object)vApp);
        Task task = (Task)EasyMock.createMock(Task.class);
        URI vappLocation = URI.create("vapp");
        URI taskLocation = URI.create("task");
        EasyMock.expect((Object)vApp.getHref()).andReturn((Object)vappLocation).atLeastOnce();
        EasyMock.expect((Object)vApp.getName()).andReturn((Object)"name").atLeastOnce();
        EasyMock.expect((Object)client.deployVApp(vappLocation)).andReturn((Object)task);
        EasyMock.expect((Object)task.getHref()).andReturn((Object)taskLocation).atLeastOnce();
        Predicate successTester = (Predicate)EasyMock.createMock(Predicate.class);
        EasyMock.expect((Object)successTester.apply((Object)taskLocation)).andReturn((Object)true).atLeastOnce();
        EasyMock.expect((Object)client.powerOnVApp(vappLocation)).andReturn((Object)task);
        Predicate notFoundTester = (Predicate)EasyMock.createMock(Predicate.class);
        Map vAppStatusToNodeStatus = (Map)EasyMock.createMock(Map.class);
        TerremarkVCloudComputeClient computeClient = new TerremarkVCloudComputeClient(client, (Provider)new Provider<String>(){

            public String get() {
                return "password";
            }
        }, successTester, vAppStatusToNodeStatus, (Map)credentialStore, supplier);
        EasyMock.replay((Object[])new Object[]{vdc});
        EasyMock.replay((Object[])new Object[]{template});
        EasyMock.replay((Object[])new Object[]{vApp});
        EasyMock.replay((Object[])new Object[]{task});
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{successTester});
        EasyMock.replay((Object[])new Object[]{notFoundTester});
        EasyMock.replay((Object[])new Object[]{vAppStatusToNodeStatus});
        ComputeServiceAdapter.NodeAndInitialCredentials response = computeClient.startAndReturnCredentials(vdcURI, templateURI, "name", new InstantiateVAppTemplateOptions(), new int[0]);
        Assert.assertEquals((String)response.getNodeId(), (String)"vapp");
        Assert.assertEquals((Object)response.getNode(), (Object)vApp);
        Assert.assertEquals((Object)response.getCredentials(), (Object)LoginCredentials.builder().password("password").build());
        EasyMock.verify((Object[])new Object[]{vdc});
        EasyMock.verify((Object[])new Object[]{template});
        EasyMock.verify((Object[])new Object[]{vApp});
        EasyMock.verify((Object[])new Object[]{task});
        EasyMock.verify((Object[])new Object[]{client});
        EasyMock.verify((Object[])new Object[]{successTester});
        EasyMock.verify((Object[])new Object[]{notFoundTester});
        EasyMock.verify((Object[])new Object[]{vAppStatusToNodeStatus});
    }
}

