/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.NodeMetadataToOrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.CleanupOrphanKeys;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.DeleteKeyPair;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CleanupOrphanKeysTest {
    public void testWhenNoDeletedNodes() {
        ImmutableSet deadOnes = ImmutableSet.of();
        CleanupOrphanKeys strategy = this.setupStrategy();
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        this.verifyStrategy(strategy);
    }

    public void testWhenDeletedNodesHaveNoTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn(null).atLeastOnce();
        this.expectCleanupCredentialStore(strategy, nodeMetadata);
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    public void testWhenStillRunningWithTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        OrgAndName orgTag = new OrgAndName(URI.create("location"), "group");
        EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn((Object)orgTag).atLeastOnce();
        EasyMock.expect((Object)strategy.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()))).andReturn((Object)ImmutableSet.of((Object)nodeMetadata));
        EasyMock.expect((Object)nodeMetadata.getGroup()).andReturn((Object)orgTag.getName()).atLeastOnce();
        EasyMock.expect((Object)nodeMetadata.getStatus()).andReturn((Object)NodeMetadata.Status.RUNNING).atLeastOnce();
        this.expectCleanupCredentialStore(strategy, nodeMetadata);
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    public void testWhenTerminatedWithTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        OrgAndName orgTag = new OrgAndName(URI.create("location"), "group");
        EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn((Object)orgTag).atLeastOnce();
        EasyMock.expect((Object)strategy.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()))).andReturn((Object)ImmutableSet.of((Object)nodeMetadata));
        EasyMock.expect((Object)nodeMetadata.getGroup()).andReturn((Object)orgTag.getName()).atLeastOnce();
        EasyMock.expect((Object)nodeMetadata.getStatus()).andReturn((Object)NodeMetadata.Status.TERMINATED).atLeastOnce();
        strategy.deleteKeyPair.execute(orgTag);
        this.expectCleanupCredentialStore(strategy, nodeMetadata);
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    private void expectCleanupCredentialStore(CleanupOrphanKeys strategy, NodeMetadata nodeMetadata) {
        EasyMock.expect((Object)("node#" + nodeMetadata.getId())).andReturn((Object)"1");
        EasyMock.expect(strategy.credentialStore.remove("node#1")).andReturn(null);
    }

    public void testWhenNoneLeftWithTag() {
        CleanupOrphanKeys strategy = this.setupStrategy();
        NodeMetadata nodeMetadata = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        ImmutableSet deadOnes = ImmutableSet.of((Object)nodeMetadata);
        OrgAndName orgTag = new OrgAndName(URI.create("location"), "group");
        EasyMock.expect((Object)strategy.nodeToOrgAndName.apply((Object)nodeMetadata)).andReturn((Object)orgTag).atLeastOnce();
        EasyMock.expect((Object)strategy.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()))).andReturn((Object)ImmutableSet.of());
        strategy.deleteKeyPair.execute(orgTag);
        this.expectCleanupCredentialStore(strategy, nodeMetadata);
        EasyMock.replay((Object[])new Object[]{nodeMetadata});
        this.replayStrategy(strategy);
        strategy.execute((Iterable)deadOnes);
        EasyMock.verify((Object[])new Object[]{nodeMetadata});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(CleanupOrphanKeys strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.nodeToOrgAndName});
        EasyMock.verify((Object[])new Object[]{strategy.deleteKeyPair});
        EasyMock.verify((Object[])new Object[]{strategy.listNodes});
        EasyMock.verify((Object[])new Object[]{strategy.credentialStore});
    }

    private CleanupOrphanKeys setupStrategy() {
        NodeMetadataToOrgAndName nodeToOrgAndName = (NodeMetadataToOrgAndName)EasyMock.createMock(NodeMetadataToOrgAndName.class);
        DeleteKeyPair deleteKeyPair = (DeleteKeyPair)EasyMock.createMock(DeleteKeyPair.class);
        ListNodesStrategy listNodes = (ListNodesStrategy)EasyMock.createMock(ListNodesStrategy.class);
        Map credentialStore = (Map)EasyMock.createMock(Map.class);
        return new CleanupOrphanKeys((Function)nodeToOrgAndName, deleteKeyPair, credentialStore, listNodes);
    }

    private void replayStrategy(CleanupOrphanKeys strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.nodeToOrgAndName});
        EasyMock.replay((Object[])new Object[]{strategy.deleteKeyPair});
        EasyMock.replay((Object[])new Object[]{strategy.listNodes});
        EasyMock.replay((Object[])new Object[]{strategy.credentialStore});
    }
}

