/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.easymock.EasyMock;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.CreateUniqueKeyPair;
import org.jclouds.trmk.vcloud_0_8.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.CreateNewKeyPairUnlessUserSpecifiedOtherwise;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairHandlerTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateNewKeyPairUnlessUserSpecifiedOtherwiseTest {
    public void testExecuteWithDefaultOptionsAlreadyHasKey() throws SecurityException, NoSuchMethodException {
        URI org = URI.create("org1");
        String identity = "identity";
        String group = "group";
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        LoginCredentials keyPairCredentials = LoginCredentials.builder().privateKey(KeyPairHandlerTest.keyPair.getPrivateKey()).build();
        EasyMock.expect((Object)strategy.credentialStore.containsKey("group#group")).andReturn((Object)true);
        EasyMock.expect(strategy.credentialStore.get("group#group")).andReturn((Object)keyPairCredentials);
        this.replayStrategy(strategy);
        strategy.execute(org, group, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)KeyPairHandlerTest.keyPair.getFingerPrint());
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_reusesKeyWhenToldTo() {
        URI org = URI.create("org1");
        String identity = "identity";
        String group = "group";
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.sshKeyFingerprint((String)"fingerprintFromUser");
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        this.replayStrategy(strategy);
        strategy.execute(org, group, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)"fingerprintFromUser");
        this.verifyStrategy(strategy);
    }

    @Test(enabled=false)
    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_createsNewKeyPairAndReturnsItsNameByDefault() {
        URI org = URI.create("org1");
        String identity = "identity";
        String group = "group";
        String systemGeneratedFingerprint = "systemGeneratedKeyPairfinger";
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        LoginCredentials keyPairCredentials = LoginCredentials.builder().privateKey(KeyPairHandlerTest.keyPair.getPrivateKey()).build();
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)strategy.credentialStore.containsKey("group#group")).andReturn((Object)false);
        EasyMock.expect((Object)strategy.createUniqueKeyPair.apply(new OrgAndName(org, "group"))).andReturn((Object)keyPair);
        EasyMock.expect((Object)keyPair.getFingerPrint()).andReturn((Object)KeyPairHandlerTest.keyPair.getFingerPrint()).atLeastOnce();
        EasyMock.expect((Object)strategy.credentialStore.put("group#group", keyPairCredentials)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(org, group, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)systemGeneratedFingerprint);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testCreateNewKeyPairUnlessUserSpecifiedOtherwise_doesntCreateAKeyPairAndReturnsNullWhenToldNotTo() {
        URI org = URI.create("org1");
        String identity = "identity";
        String group = "group";
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.noKeyPair();
        CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy = this.setupStrategy();
        this.replayStrategy(strategy);
        strategy.execute(org, group, identity, options);
        Assert.assertEquals((String)options.getSshKeyFingerprint(), null);
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.credentialStore});
        EasyMock.verify((Object[])new Object[]{strategy.createUniqueKeyPair});
    }

    private CreateNewKeyPairUnlessUserSpecifiedOtherwise setupStrategy() {
        Map credentialStore = (Map)EasyMock.createMock(ConcurrentMap.class);
        CreateUniqueKeyPair createUniqueKeyPair = (CreateUniqueKeyPair)EasyMock.createMock(CreateUniqueKeyPair.class);
        return new CreateNewKeyPairUnlessUserSpecifiedOtherwise(credentialStore, createUniqueKeyPair);
    }

    private void replayStrategy(CreateNewKeyPairUnlessUserSpecifiedOtherwise strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.credentialStore});
        EasyMock.replay((Object[])new Object[]{strategy.createUniqueKeyPair});
    }
}

