/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.easymock.EasyMock;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.DeleteKeyPair;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DeleteKeyPairTest {
    public void testWhenNoKeyPairsInOrg() {
        URI org = URI.create("org1");
        OrgAndName orgTag = new OrgAndName(org, "tag");
        DeleteKeyPair strategy = this.setupStrategy();
        EasyMock.expect((Object)strategy.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())).andReturn((Object)ImmutableSet.of());
        this.replayStrategy(strategy);
        strategy.execute(orgTag);
        this.verifyStrategy(strategy);
    }

    public void testWhenKeyPairMatches() {
        URI org = URI.create("org1");
        OrgAndName orgTag = new OrgAndName(org, "tag");
        DeleteKeyPair strategy = this.setupStrategy();
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)strategy.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())).andReturn((Object)ImmutableSet.of((Object)keyPair));
        EasyMock.expect((Object)keyPair.getName()).andReturn((Object)("jclouds_" + orgTag.getName() + "_123")).atLeastOnce();
        EasyMock.expect((Object)keyPair.getId()).andReturn((Object)URI.create("1245"));
        strategy.terremarkClient.deleteKeyPair(URI.create("1245"));
        EasyMock.expect(strategy.credentialStore.remove("group#tag")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(orgTag);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    public void testWhenKeyPairDoesntMatch() {
        URI org = URI.create("org1");
        OrgAndName orgTag = new OrgAndName(org, "tag");
        DeleteKeyPair strategy = this.setupStrategy();
        KeyPair keyPair = (KeyPair)EasyMock.createMock(KeyPair.class);
        EasyMock.expect((Object)strategy.terremarkClient.listKeyPairsInOrg(orgTag.getOrg())).andReturn((Object)ImmutableSet.of((Object)keyPair));
        EasyMock.expect((Object)keyPair.getName()).andReturn((Object)("kclouds_" + orgTag.getName() + "_123"));
        EasyMock.replay((Object[])new Object[]{keyPair});
        this.replayStrategy(strategy);
        strategy.execute(orgTag);
        EasyMock.verify((Object[])new Object[]{keyPair});
        this.verifyStrategy(strategy);
    }

    private void verifyStrategy(DeleteKeyPair strategy) {
        EasyMock.verify((Object[])new Object[]{strategy.credentialStore});
        EasyMock.verify((Object[])new Object[]{strategy.terremarkClient});
    }

    private DeleteKeyPair setupStrategy() {
        Map credentialStore = (Map)EasyMock.createMock(ConcurrentMap.class);
        TerremarkVCloudClient terremarkClient = (TerremarkVCloudClient)EasyMock.createMock(TerremarkVCloudClient.class);
        return new DeleteKeyPair(terremarkClient, credentialStore);
    }

    private void replayStrategy(DeleteKeyPair strategy) {
        EasyMock.replay((Object[])new Object[]{strategy.credentialStore});
        EasyMock.replay((Object[])new Object[]{strategy.terremarkClient});
    }
}

