/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.suppliers;

import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.suppliers.VAppTemplatesInOrgs;
import org.jclouds.trmk.vcloud_0_8.functions.AllCatalogItemsInOrg;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="VAppTemplatesInOrgsLiveTest")
public class VAppTemplatesInOrgsLiveTest
extends BaseComputeServiceContextLiveTest {
    private TerremarkVCloudClient tmClient;
    private VAppTemplatesInOrgs parser;
    private AllCatalogItemsInOrg allCatalogItemsInOrg;

    public VAppTemplatesInOrgsLiveTest() {
        this.provider = "trmk-vcloudexpress";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        Injector injector = ((ComputeServiceContext)this.view).utils().injector();
        this.tmClient = (TerremarkVCloudClient)injector.getInstance(TerremarkVCloudClient.class);
        this.allCatalogItemsInOrg = (AllCatalogItemsInOrg)injector.getInstance(AllCatalogItemsInOrg.class);
        this.parser = (VAppTemplatesInOrgs)injector.getInstance(VAppTemplatesInOrgs.class);
    }

    @Test
    public void testParseAllImages() {
        Set images = this.parser.get();
        Iterable templates = this.allCatalogItemsInOrg.apply(this.tmClient.findOrgNamed(null));
        Assert.assertEquals((int)images.size(), (int)Iterables.size((Iterable)templates));
        assert (images.size() > 0);
    }
}

