/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.functions.ParseLoginResponseFromHeaders;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseLoginResponseFromHeadersTest")
public class ParseLoginResponseFromHeadersTest
extends BaseHandlerTest {
    private ParseLoginResponseFromHeaders parser;

    @BeforeTest
    void setUp() {
        this.parser = (ParseLoginResponseFromHeaders)this.injector.getInstance(ParseLoginResponseFromHeaders.class);
    }

    @Test
    public void testApply() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).addHeader("x-vcloud-authorization", new String[]{"vcloud-token=9er4d061-4bff-48fa-84b1-5da7166764d2; path=/"})).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        VCloudSession reply = this.parser.apply(response);
        Assert.assertEquals((String)reply.getVCloudToken(), (String)"9er4d061-4bff-48fa-84b1-5da7166764d2");
        Assert.assertEquals((Map)reply.getOrgs(), (Map)ImmutableMap.of((Object)"adrian@jclouds.org", (Object)new ReferenceTypeImpl("adrian@jclouds.org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"))));
    }

    @Test
    public void testApplyBlueLock() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).addHeader("x-vcloud-authorization", new String[]{"MUKOJ2HoAfoMmLnHRp4esNb2MtWscCLLhVysnsIsCG0="})).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        VCloudSession reply = this.parser.apply(response);
        Assert.assertEquals((String)reply.getVCloudToken(), (String)"MUKOJ2HoAfoMmLnHRp4esNb2MtWscCLLhVysnsIsCG0=");
        Assert.assertEquals((Map)reply.getOrgs(), (Map)ImmutableMap.of((Object)"adrian@jclouds.org", (Object)new ReferenceTypeImpl("adrian@jclouds.org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"))));
    }

    @Test
    public void testApplyTerremark() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).addHeader("Set-Cookie", new String[]{"vcloud-token=37ce2715-9aba-4f48-8e45-2db8a8da702d; path=/"})).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        VCloudSession reply = this.parser.apply(response);
        Assert.assertEquals((String)reply.getVCloudToken(), (String)"37ce2715-9aba-4f48-8e45-2db8a8da702d");
        Assert.assertEquals((Map)reply.getOrgs(), (Map)ImmutableMap.of((Object)"adrian@jclouds.org", (Object)new ReferenceTypeImpl("adrian@jclouds.org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"))));
    }

    @Test
    public void testApplyTerremarkMultipleCookies() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).addHeader("Set-Cookie", new String[]{"NSC_ESUO_21654_72.46.239.132_443=fooo;expires=Thu, 02-Jun-2011 17:19:26 GMT;path=/;secure;httponly"})).addHeader("Set-Cookie", new String[]{"vcloud-token=37ce2715-9aba-4f48-8e45-2db8a8da702d; path=/"})).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        VCloudSession reply = this.parser.apply(response);
        Assert.assertEquals((String)reply.getVCloudToken(), (String)"37ce2715-9aba-4f48-8e45-2db8a8da702d");
        Assert.assertEquals((Map)reply.getOrgs(), (Map)ImmutableMap.of((Object)"adrian@jclouds.org", (Object)new ReferenceTypeImpl("adrian@jclouds.org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"))));
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testUnmatchedCookieThrowsHttpResponseException() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).addHeader("Set-Cookie", new String[]{"NSC_ESUO_21654_72.46.239.132_443=fooo;expires=Thu, 02-Jun-2011 17:19:26 GMT;path=/;secure;httponly"})).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        this.parser.apply(response);
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testNoThrowsHttpResponseException() {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        this.parser.apply(response);
    }

    @Test
    public void testApplyVirtacore() {
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("OK").payload(((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml"))).addHeader("x-vcloud-authorization", new String[]{"vcloud-token=IPy0w7UGD4lwtdWAK/ZVzfuLK+dztxGRqsOhWqV0i48="})).build();
        response.getPayload().getContentMetadata().setContentType("Content-Type: application/xml; charset=utf-8");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(307L));
        VCloudSession reply = this.parser.apply(response);
        Assert.assertEquals((String)reply.getVCloudToken(), (String)"IPy0w7UGD4lwtdWAK/ZVzfuLK+dztxGRqsOhWqV0i48=");
        Assert.assertEquals((Map)reply.getOrgs(), (Map)ImmutableMap.of((Object)"adrian@jclouds.org", (Object)new ReferenceTypeImpl("adrian@jclouds.org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"))));
    }
}

