/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.xml.CatalogHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CatalogHandlerTest {
    private Injector injector;
    private ParseSax.Factory factory;

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/catalog.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        Catalog result = (Catalog)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(CatalogHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Miami Environment 1");
        assert (result.getDescription() == null);
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32/catalog"));
        Assert.assertEquals((Object)result.get((Object)"CentOS 5.3 (32-bit)"), (Object)new ReferenceTypeImpl("CentOS 5.3 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/5")));
        Assert.assertEquals((Object)result.get((Object)"CentOS 5.3 (64-bit)"), (Object)new ReferenceTypeImpl("CentOS 5.3 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/6")));
        Assert.assertEquals((Object)result.get((Object)"RHEL 5.3 (32-bit)"), (Object)new ReferenceTypeImpl("RHEL 5.3 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/7")));
        Assert.assertEquals((Object)result.get((Object)"RHEL 5.3 (64-bit)"), (Object)new ReferenceTypeImpl("RHEL 5.3 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/8")));
        Assert.assertEquals((Object)result.get((Object)"Ubuntu JeOS 9.04 (32-bit)"), (Object)new ReferenceTypeImpl("Ubuntu JeOS 9.04 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/11")));
        Assert.assertEquals((Object)result.get((Object)"Ubuntu JeOS 9.04 (64-bit)"), (Object)new ReferenceTypeImpl("Ubuntu JeOS 9.04 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/12")));
        Assert.assertEquals((Object)result.get((Object)"Ubuntu Server 9.04 (32-bit)"), (Object)new ReferenceTypeImpl("Ubuntu Server 9.04 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/9")));
        Assert.assertEquals((Object)result.get((Object)"Ubuntu Server 9.04 (64-bit)"), (Object)new ReferenceTypeImpl("Ubuntu Server 9.04 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/10")));
        Assert.assertEquals((Object)result.get((Object)"Windows 2003 Enterprise R2 (32-bit)"), (Object)new ReferenceTypeImpl("Windows 2003 Enterprise R2 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/1")));
        Assert.assertEquals((Object)result.get((Object)"Windows 2003 Enterprise R2 (64-bit)"), (Object)new ReferenceTypeImpl("Windows 2003 Enterprise R2 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/2")));
        Assert.assertEquals((Object)result.get((Object)"Windows 2003 Standard R2 (32-bit)"), (Object)new ReferenceTypeImpl("Windows 2003 Standard R2 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/3")));
        Assert.assertEquals((Object)result.get((Object)"Windows 2003 Standard R2 (64-bit)"), (Object)new ReferenceTypeImpl("Windows 2003 Standard R2 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/4")));
        Assert.assertEquals((Object)result.get((Object)"Windows 2003 Standard R2 w.SQL 2008 Web (64-bit)"), (Object)new ReferenceTypeImpl("Windows 2003 Standard R2 w.SQL 2008 Web (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/23")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Enterprise (32-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Enterprise (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/13")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Enterprise (64-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Enterprise (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/15")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Enterprise R2 (64-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Enterprise R2 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/16")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Standard (32-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Standard (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/17")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Standard (64-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Standard (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/18")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Standard R2 (64-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Standard R2 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/19")));
        Assert.assertEquals((Object)result.get((Object)"Windows Server 2008 Standard w.SQL 2008 Web (64-bit)"), (Object)new ReferenceTypeImpl("Windows Server 2008 Standard w.SQL 2008 Web (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/14")));
        Assert.assertEquals((Object)result.get((Object)"Windows Web Server 2008 (32-bit)"), (Object)new ReferenceTypeImpl("Windows Web Server 2008 (32-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/20")));
        Assert.assertEquals((Object)result.get((Object)"Windows Web Server 2008 (64-bit)"), (Object)new ReferenceTypeImpl("Windows Web Server 2008 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/21")));
        Assert.assertEquals((Object)result.get((Object)"Windows Web Server 2008 R2 (64-bit)"), (Object)new ReferenceTypeImpl("Windows Web Server 2008 R2 (64-bit)", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/catalogItem/22")));
    }
}

