/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairByNameHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="KeyPairByNameHandlerTest")
public class KeyPairByNameHandlerTest
extends BaseHandlerTest {
    public void testGood() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keysList.xml");
        KeyPair result = (KeyPair)this.factory.create((ParseSax.HandlerWithResult)this.addOrgAndNameToHandler((KeyPairByNameHandler)this.injector.getInstance(KeyPairByNameHandler.class), "org", "default")).parse(is);
        Assert.assertEquals((Object)result, (Object)new KeyPair(URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/extensions/key/9"), "default", true, null, "4e:af:8a:9f:e9:d2:72:d7:4b:a0:da:98:72:98:4d:7d"));
    }

    public void testNotFound() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keysList.xml");
        KeyPair result = (KeyPair)this.factory.create((ParseSax.HandlerWithResult)this.addOrgAndNameToHandler((KeyPairByNameHandler)this.injector.getInstance(KeyPairByNameHandler.class), "org", "monster")).parse(is);
        Assert.assertNull((Object)result);
    }

    private KeyPairByNameHandler addOrgAndNameToHandler(KeyPairByNameHandler handler, String org, String name) {
        handler.setContext((HttpRequest)this.requestForArgs((List)ImmutableList.of((Object)org, (Object)name)));
        return handler;
    }
}

