/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.FenceMode;
import org.jclouds.trmk.vcloud_0_8.domain.Network;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.internal.NetworkImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.xml.NetworkHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class NetworkHandlerTest {
    private Injector injector;
    private ParseSax.Factory factory;

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/network-terremark.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        Network result = (Network)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(NetworkHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new NetworkImpl("10.122.209.128/28", "application/vnd.vmware.vcloud.network+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/network/40031"), null, "10.122.209.129", "255.255.255.240", FenceMode.ISOLATED, (ReferenceType)new ReferenceTypeImpl("10.122.209.128/28", "application/xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/extensions/network/40031")), (ReferenceType)new ReferenceTypeImpl("IP Addresses", "application/xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/extensions/network/40031/ips"))));
    }
}

