/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudApiMetadata;
import org.jclouds.trmk.vcloud_0_8.xml.OrgHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OrgHandlerTest")
public class OrgHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                Names.bindProperties((Binder)this.binder(), (Properties)TerremarkVCloudApiMetadata.defaultProperties());
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org.xml");
        Org result = (Org)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(OrgHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"adrian@jclouds.org");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/org/48"));
        Assert.assertEquals((Map)result.getCatalogs(), (Map)ImmutableMap.of((Object)"Miami Environment 1 Catalog", (Object)new ReferenceTypeImpl("Miami Environment 1 Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32/catalog"))));
        Assert.assertEquals((Map)result.getVDCs(), (Map)ImmutableMap.of((Object)"Miami Environment 1", (Object)new ReferenceTypeImpl("Miami Environment 1", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32"))));
        Assert.assertEquals((Map)result.getTasksLists(), (Map)ImmutableMap.of((Object)"Miami Environment 1 Tasks List", (Object)new ReferenceTypeImpl("Miami Environment 1 Tasks List", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32/tasksList"))));
        Assert.assertEquals((Object)result.getKeys(), (Object)new ReferenceTypeImpl("Keys", "application/vnd.tmrk.vcloudExpress.keysList+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/extensions/org/48/keys")));
    }
}

