/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import java.io.InputStream;
import java.net.URI;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.TaskStatus;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudError;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ErrorImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.TaskImpl;
import org.jclouds.trmk.vcloud_0_8.xml.TaskHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TaskHandlerTest")
public class TaskHandlerTest
extends BaseHandlerTest {
    private DateService dateService;

    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
    }

    public void testTerremark() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/task/3299"), null, TaskStatus.SUCCESS, this.dateService.iso8601DateParse("2009-08-24T21:29:32.983Z"), this.dateService.iso8601DateParse("2009-08-24T21:29:44.65Z"), null, (ReferenceType)new ReferenceTypeImpl("Server1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/4012")), null);
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testSelf() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-self.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("https://vcloud.safesecureweb.com/api/v0.8/task/d188849-78"), null, TaskStatus.QUEUED, null, null, null, null, null);
        Assert.assertEquals((Object)result, (Object)expects);
    }

    public void testError() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/task-error.xml");
        Task result = (Task)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TaskHandler.class)).parse(is);
        TaskImpl expects = new TaskImpl(URI.create("http://10.150.4.49/api/v0.8/task/23"), null, TaskStatus.ERROR, this.dateService.iso8601SecondsDateParse("2009-12-07T19:05:02Z"), this.dateService.iso8601SecondsDateParse("2009-12-10T14:40:32Z"), null, (ReferenceType)new ReferenceTypeImpl("testapp1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("http://10.150.4.49/api/v0.8/vapp/1")), (VCloudError)new ErrorImpl("Error processing job", 500, VCloudError.MinorCode.UNRECOGNIZED, " Error in runDailySummaries date used:2009-12-09 19:40:30.577326+00:00", null));
        Assert.assertEquals((Object)result, (Object)expects);
    }
}

