/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;

@Singleton
public class OrgNameAndTasksListNameToEndpoint
implements MapBinder {
    private final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultTasksList;

    @Inject
    public OrgNameAndTasksListNameToEndpoint(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap, @Org Supplier<ReferenceType> defaultOrg, @TasksList Supplier<ReferenceType> defaultTasksList) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultOrg;
        this.defaultTasksList = defaultTasksList;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Object org = postParams.get("orgName");
        Object tasksList = postParams.get("tasksListName");
        if (org == null && tasksList == null) {
            return (R)request.toBuilder().endpoint(((ReferenceType)this.defaultTasksList.get()).getHref()).build();
        }
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        try {
            Map<String, ReferenceType> tasksLists = ((org.jclouds.trmk.vcloud_0_8.domain.Org)Preconditions.checkNotNull(((Map)this.orgMap.get()).get(org))).getTasksLists();
            URI endpoint = tasksList == null ? ((ReferenceType)Iterables.getLast(tasksLists.values())).getHref() : tasksLists.get(tasksList).getHref();
            return (R)request.toBuilder().endpoint(endpoint).build();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + tasksList + " not found in " + this.orgMap.get());
        }
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException(this.getClass() + " needs parameters");
    }
}

