/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.binders.OrgNameVDCNameResourceNameToEndpoint;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameVDCNameNetworkNameToEndpoint
extends OrgNameVDCNameResourceNameToEndpoint {
    @Inject
    public OrgNameVDCNameNetworkNameToEndpoint(Supplier<Map<String, Map<String, ? extends VDC>>> orgVDCMap, @Org Supplier<ReferenceType> defaultOrg, @org.jclouds.trmk.vcloud_0_8.endpoints.VDC Supplier<ReferenceType> defaultVDC) {
        super(orgVDCMap, defaultOrg, defaultVDC);
    }

    @Override
    protected URI getEndpointOfResourceInVDC(Object org, Object vDC, Object resource, VDC vDCObject) {
        ReferenceType resourceEntity = vDCObject.getAvailableNetworks().get(resource);
        if (resourceEntity == null) {
            throw new NoSuchElementException("network " + resource + " in vdc " + vDC + ", org " + org + " not found in " + vDCObject.getAvailableNetworks().keySet());
        }
        return resourceEntity.getHref();
    }
}

