/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.TaskStatus;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudError;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;

public class TaskImpl
extends ReferenceTypeImpl
implements Task {
    private final String operation;
    private final TaskStatus status;
    private final Date startTime;
    @Nullable
    private final Date endTime;
    @Nullable
    private final Date expiryTime;
    private final ReferenceType owner;
    @Nullable
    private final VCloudError error;

    public TaskImpl(URI id, String operation, TaskStatus status, Date startTime, @Nullable Date endTime, @Nullable Date expiryTime, ReferenceType owner, VCloudError error) {
        super(null, "application/vnd.vmware.vcloud.task+xml", id);
        this.operation = operation;
        this.status = (TaskStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.startTime = startTime;
        this.endTime = endTime;
        this.expiryTime = expiryTime;
        this.owner = owner;
        this.error = error;
    }

    @Override
    public TaskStatus getStatus() {
        return this.status;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public ReferenceType getOwner() {
        return this.owner;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public VCloudError getError() {
        return this.error;
    }

    @Override
    public String toString() {
        return "TaskImpl [endTime=" + this.endTime + ", error=" + this.error + ", expiryTime=" + this.expiryTime + ", operation=" + this.operation + ", owner=" + this.owner + ", startTime=" + this.startTime + ", status=" + (Object)((Object)this.status) + ", getHref()=" + this.getHref() + ", getName()=" + this.getName() + ", getType()=" + this.getType() + ", toString()=" + super.toString() + ", getClass()=" + this.getClass() + "]";
    }

    @Override
    public Date getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.expiryTime == null ? 0 : this.expiryTime.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskImpl other = (TaskImpl)obj;
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.expiryTime == null ? other.expiryTime != null : !this.expiryTime.equals(other.expiryTime)) {
            return false;
        }
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }
}

