/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.FenceMode;

public class InstantiateVAppTemplateOptions {
    private Set<NetworkConfig> networkConfig = Sets.newLinkedHashSet();
    private Boolean customizeOnInstantiate;
    private String cpuCount;
    private String memorySizeMegabytes;
    private boolean block = true;
    private boolean deploy = true;
    private boolean powerOn = true;
    private final Map<String, String> properties = Maps.newLinkedHashMap();

    public InstantiateVAppTemplateOptions sshKeyFingerprint(String sshKeyFingerprint) {
        this.productProperty("sshKeyFingerprint", sshKeyFingerprint);
        return this;
    }

    public InstantiateVAppTemplateOptions primaryDNS(String primaryDNS) {
        this.productProperty("primaryDNS", primaryDNS);
        return this;
    }

    public InstantiateVAppTemplateOptions secondaryDNS(String secondaryDNS) {
        this.productProperty("secondaryDNS", secondaryDNS);
        return this;
    }

    public InstantiateVAppTemplateOptions withPassword(String password) {
        this.productProperty("password", password);
        return this;
    }

    public InstantiateVAppTemplateOptions inGroup(String group) {
        this.productProperty("group", group);
        return this;
    }

    public InstantiateVAppTemplateOptions inRow(String row) {
        this.productProperty("row", row);
        return this;
    }

    public InstantiateVAppTemplateOptions productProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public InstantiateVAppTemplateOptions productProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean shouldBlock() {
        return this.block;
    }

    public boolean shouldDeploy() {
        return this.deploy;
    }

    public boolean shouldPowerOn() {
        return this.powerOn;
    }

    public InstantiateVAppTemplateOptions deploy(boolean deploy) {
        this.deploy = deploy;
        return this;
    }

    public InstantiateVAppTemplateOptions powerOn(boolean powerOn) {
        this.powerOn = powerOn;
        return this;
    }

    public InstantiateVAppTemplateOptions block(boolean block) {
        this.block = block;
        return this;
    }

    public InstantiateVAppTemplateOptions customizeOnInstantiate(boolean customizeOnInstantiate) {
        this.customizeOnInstantiate = customizeOnInstantiate;
        return this;
    }

    public InstantiateVAppTemplateOptions processorCount(int cpuCount) {
        Preconditions.checkArgument((cpuCount >= 1 ? 1 : 0) != 0, (Object)"cpuCount must be positive");
        this.cpuCount = cpuCount + "";
        return this;
    }

    public InstantiateVAppTemplateOptions memory(long megabytes) {
        Preconditions.checkArgument((megabytes >= 1L ? 1 : 0) != 0, (Object)"megabytes must be positive");
        this.memorySizeMegabytes = megabytes + "";
        return this;
    }

    public InstantiateVAppTemplateOptions addNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig.add((NetworkConfig)Preconditions.checkNotNull((Object)networkConfig, (Object)"networkConfig"));
        return this;
    }

    public Set<NetworkConfig> getNetworkConfig() {
        return this.networkConfig;
    }

    public String getCpuCount() {
        return this.cpuCount;
    }

    public Boolean shouldCustomizeOnInstantiate() {
        return this.customizeOnInstantiate;
    }

    public String getMemorySizeMegabytes() {
        return this.memorySizeMegabytes;
    }

    public String toString() {
        return "[cpuCount=" + this.cpuCount + ", memorySizeMegabytes=" + this.memorySizeMegabytes + ", networkConfig=" + this.networkConfig + ", customizeOnInstantiate=" + this.customizeOnInstantiate + ", deploy=" + this.deploy + ", powerOn=" + this.powerOn + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block ? 1231 : 1237);
        result = 31 * result + (this.cpuCount == null ? 0 : this.cpuCount.hashCode());
        result = 31 * result + (this.customizeOnInstantiate == null ? 0 : this.customizeOnInstantiate.hashCode());
        result = 31 * result + (this.deploy ? 1231 : 1237);
        result = 31 * result + (this.memorySizeMegabytes == null ? 0 : this.memorySizeMegabytes.hashCode());
        result = 31 * result + (this.networkConfig == null ? 0 : this.networkConfig.hashCode());
        result = 31 * result + (this.powerOn ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstantiateVAppTemplateOptions other = (InstantiateVAppTemplateOptions)obj;
        if (this.block != other.block) {
            return false;
        }
        if (this.cpuCount == null ? other.cpuCount != null : !this.cpuCount.equals(other.cpuCount)) {
            return false;
        }
        if (this.customizeOnInstantiate == null ? other.customizeOnInstantiate != null : !this.customizeOnInstantiate.equals(other.customizeOnInstantiate)) {
            return false;
        }
        if (this.deploy != other.deploy) {
            return false;
        }
        if (this.memorySizeMegabytes == null ? other.memorySizeMegabytes != null : !this.memorySizeMegabytes.equals(other.memorySizeMegabytes)) {
            return false;
        }
        if (this.networkConfig == null ? other.networkConfig != null : !this.networkConfig.equals(other.networkConfig)) {
            return false;
        }
        return this.powerOn == other.powerOn;
    }

    public static class Builder {
        public static InstantiateVAppTemplateOptions block(boolean block) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.block(block);
        }

        public static InstantiateVAppTemplateOptions deploy(boolean deploy) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.deploy(deploy);
        }

        public static InstantiateVAppTemplateOptions powerOn(boolean powerOn) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.powerOn(powerOn);
        }

        public static InstantiateVAppTemplateOptions processorCount(int cpuCount) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.processorCount(cpuCount);
        }

        public static InstantiateVAppTemplateOptions customizeOnInstantiate(Boolean customizeOnInstantiate) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.customizeOnInstantiate(customizeOnInstantiate);
        }

        public static InstantiateVAppTemplateOptions memory(int megabytes) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.memory(megabytes);
        }

        public static InstantiateVAppTemplateOptions addNetworkConfig(NetworkConfig networkConfig) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.addNetworkConfig(networkConfig);
        }

        public static InstantiateVAppTemplateOptions withPassword(String password) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.withPassword(password);
        }

        public static InstantiateVAppTemplateOptions inGroup(String group) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.inGroup(group);
        }

        public static InstantiateVAppTemplateOptions inRow(String row) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.inRow(row);
        }

        public static InstantiateVAppTemplateOptions sshKeyFingerprint(String sshKeyFingerprint) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.sshKeyFingerprint(sshKeyFingerprint);
        }

        public static InstantiateVAppTemplateOptions primaryDNS(String primaryDNS) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.primaryDNS(primaryDNS);
        }

        public static InstantiateVAppTemplateOptions secondaryDNS(String secondaryDNS) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.secondaryDNS(secondaryDNS);
        }

        public static InstantiateVAppTemplateOptions productProperty(String key, String value) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.productProperty(key, value);
        }

        public static InstantiateVAppTemplateOptions productProperties(Map<String, String> properties) {
            InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
            return options.productProperties(properties);
        }
    }

    public static class NetworkConfig {
        @Nullable
        private final String networkName;
        private final URI parentNetwork;
        @Nullable
        private final FenceMode fenceMode;

        public NetworkConfig(String networkName, URI parentNetwork, FenceMode fenceMode) {
            this.networkName = networkName;
            this.parentNetwork = (URI)Preconditions.checkNotNull((Object)parentNetwork, (Object)"parentNetwork");
            this.fenceMode = fenceMode;
        }

        public NetworkConfig(URI parentNetwork) {
            this(null, parentNetwork, null);
        }

        public String getNetworkName() {
            return this.networkName;
        }

        public URI getParentNetwork() {
            return this.parentNetwork;
        }

        public FenceMode getFenceMode() {
            return this.fenceMode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fenceMode == null ? 0 : this.fenceMode.hashCode());
            result = 31 * result + (this.parentNetwork == null ? 0 : this.parentNetwork.hashCode());
            result = 31 * result + (this.networkName == null ? 0 : this.networkName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkConfig other = (NetworkConfig)obj;
            if (this.fenceMode == null ? other.fenceMode != null : !this.fenceMode.equals((Object)other.fenceMode)) {
                return false;
            }
            if (this.parentNetwork == null ? other.parentNetwork != null : !this.parentNetwork.equals(other.parentNetwork)) {
                return false;
            }
            return !(this.networkName == null ? other.networkName != null : !this.networkName.equals(other.networkName));
        }

        public String toString() {
            return "[networkName=" + this.networkName + ", parentNetwork=" + this.parentNetwork + ", fenceMode=" + (Object)((Object)this.fenceMode) + "]";
        }
    }
}

