/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae.config;

import com.google.appengine.api.ThreadManager;
import com.google.apphosting.api.ApiProxy;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.DynamicExecutors;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.WithSubmissionTrace;

@ConfiguresExecutorService
@Beta
public class CurrentRequestExecutorServiceModule
extends AbstractModule {
    private final Supplier<ListeningExecutorService> memoizedCurrentRequestExecutorService;

    public CurrentRequestExecutorServiceModule() {
        this(CurrentRequestExecutorServiceModule.memoizedCurrentRequestExecutorService());
    }

    public CurrentRequestExecutorServiceModule(Supplier<ListeningExecutorService> memoizedCurrentRequestExecutorService) {
        this.memoizedCurrentRequestExecutorService = memoizedCurrentRequestExecutorService;
    }

    public CurrentRequestExecutorServiceModule(ListeningExecutorService currentRequestExecutorService) {
        this.memoizedCurrentRequestExecutorService = Suppliers.ofInstance((Object)currentRequestExecutorService);
    }

    protected void configure() {
    }

    public static Supplier<ListeningExecutorService> memoizedCurrentRequestExecutorService() {
        return Suppliers.memoize((Supplier)new Supplier<ListeningExecutorService>(){

            public ListeningExecutorService get() {
                return CurrentRequestExecutorServiceModule.currentRequestExecutorService();
            }
        });
    }

    public static ListeningExecutorService currentRequestExecutorService() {
        ThreadFactory factory = (ThreadFactory)Preconditions.checkNotNull((Object)ThreadManager.currentRequestThreadFactory(), (Object)"ThreadManager.currentRequestThreadFactory()");
        int maxThreads = 10;
        long keepAlive = ApiProxy.getCurrentEnvironment().getRemainingMillis();
        ExecutorService pool = DynamicExecutors.newScalingThreadPool((int)0, (int)maxThreads, (long)keepAlive, (ThreadFactory)factory);
        return WithSubmissionTrace.wrap((ListeningExecutorService)MoreExecutors.listeningDecorator((ExecutorService)pool));
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    protected ListeningExecutorService userExecutor() {
        return (ListeningExecutorService)this.memoizedCurrentRequestExecutorService.get();
    }

    @Provides
    @Singleton
    @Named(value="jclouds.io-worker-threads")
    protected ListeningExecutorService ioExecutor() {
        return (ListeningExecutorService)this.memoizedCurrentRequestExecutorService.get();
    }
}

