/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gae.config;

import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.gae.GaeHttpCommandExecutorService;
import org.jclouds.gae.config.CurrentRequestExecutorServiceModule;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.predicates.SocketOpenUnsupported;

@ConfiguresHttpCommandExecutorService
@ConfiguresExecutorService
@SingleThreaded
public class GoogleAppEngineConfigurationModule
extends AbstractModule {
    private final Module userExecutorModule;

    public GoogleAppEngineConfigurationModule() {
        this((Module)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
    }

    public GoogleAppEngineConfigurationModule(Module userExecutorModule) {
        this.userExecutorModule = userExecutorModule;
    }

    public GoogleAppEngineConfigurationModule(Supplier<ListeningExecutorService> memoizedCurrentRequestExecutorService) {
        this.userExecutorModule = new CurrentRequestExecutorServiceModule(memoizedCurrentRequestExecutorService);
    }

    protected void configure() {
        this.install(this.userExecutorModule);
        this.bind(SocketOpen.class).to(SocketOpenUnsupported.class).in(Scopes.SINGLETON);
        this.bindHttpCommandExecutorService();
    }

    protected void bindHttpCommandExecutorService() {
        this.bind(HttpCommandExecutorService.class).to(GaeHttpCommandExecutorService.class);
    }

    @Provides
    protected URLFetchService provideURLFetchService() {
        return URLFetchServiceFactory.getURLFetchService();
    }
}

