/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch.config;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import javax.inject.Named;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.proxy.ProxyConfig;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.config.ConfiguresSshClient;
import org.jclouds.ssh.jsch.JschSshClient;

@ConfiguresSshClient
public class JschSshClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(SshClient.Factory.class).to(Factory.class).in(Scopes.SINGLETON);
    }

    private static class Factory
    implements SshClient.Factory {
        @Named(value="jclouds.connection-timeout")
        @Inject(optional=true)
        int timeout = 60000;
        private final ProxyConfig proxyConfig;
        private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
        private final Injector injector;

        @Inject
        public Factory(ProxyConfig proxyConfig, BackoffLimitedRetryHandler backoffLimitedRetryHandler, Injector injector) {
            this.proxyConfig = (ProxyConfig)Preconditions.checkNotNull((Object)proxyConfig, (Object)"proxyConfig");
            this.backoffLimitedRetryHandler = (BackoffLimitedRetryHandler)Preconditions.checkNotNull((Object)backoffLimitedRetryHandler, (Object)"backoffLimitedRetryHandler");
            this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector");
        }

        public SshClient create(HostAndPort socket, LoginCredentials credentials) {
            JschSshClient client = new JschSshClient(this.proxyConfig, this.backoffLimitedRetryHandler, socket, credentials, this.timeout);
            this.injector.injectMembers((Object)client);
            return client;
        }
    }
}

