/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.net.HostAndPort;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import org.jclouds.compute.domain.ExecChannel;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="SshjSshClientLiveTest")
public class SshjSshClientLiveTest {
    protected static final String sshHost = System.getProperty("test.ssh.host", "localhost");
    protected static final String sshPort = System.getProperty("test.ssh.port", "22");
    protected static final String sshUser = System.getProperty("test.ssh.username");
    protected static final String sshPass = System.getProperty("test.ssh.password");
    protected static final String sshKeyFile = System.getProperty("test.ssh.keyfile");
    private File temp;

    @BeforeGroups(groups={"live"})
    public SshClient setupClient() throws NumberFormatException, FileNotFoundException, IOException {
        int port = Integer.parseInt(sshPort);
        if (sshUser == null || (sshPass == null || sshPass.trim().equals("")) && (sshKeyFile == null || sshKeyFile.trim().equals("")) || sshUser.trim().equals("")) {
            System.err.println("ssh credentials not present.  Tests will be lame");
            return new SshClient(){

                public void connect() {
                }

                public void disconnect() {
                }

                public Payload get(String path) {
                    if (path.equals("/etc/passwd")) {
                        return Payloads.newStringPayload((String)"root");
                    }
                    if (path.equals(SshjSshClientLiveTest.this.temp.getAbsolutePath())) {
                        return Payloads.newStringPayload((String)"rabbit");
                    }
                    throw new RuntimeException("path " + path + " not stubbed");
                }

                public ExecResponse exec(String command) {
                    if (command.equals("hostname")) {
                        return new ExecResponse(sshHost, "", 0);
                    }
                    throw new RuntimeException("command " + command + " not stubbed");
                }

                public void put(String path, Payload contents) {
                }

                public String getHostAddress() {
                    return null;
                }

                public String getUsername() {
                    return null;
                }

                public void put(String path, String contents) {
                }

                public ExecChannel execChannel(String command) {
                    if (command.equals("hostname")) {
                        return new ExecChannel((OutputStream)new ByteArrayOutputStream(), (InputStream)new ByteArrayInputStream(sshHost.getBytes()), (InputStream)new ByteArrayInputStream(new byte[0]), Suppliers.ofInstance((Object)0), new Closeable(){

                            @Override
                            public void close() {
                            }
                        });
                    }
                    throw new RuntimeException("command " + command + " not stubbed");
                }
            };
        }
        Injector i = Guice.createInjector((Module[])new Module[]{new SshjSshClientModule(), new SLF4JLoggingModule()});
        SshClient.Factory factory = (SshClient.Factory)i.getInstance(SshClient.Factory.class);
        SshClient connection = Strings.emptyToNull((String)sshKeyFile) != null ? factory.create(HostAndPort.fromParts((String)sshHost, (int)port), LoginCredentials.builder().user(sshUser).privateKey(Files.toString((File)new File(sshKeyFile), (Charset)Charsets.UTF_8)).build()) : factory.create(HostAndPort.fromParts((String)sshHost, (int)port), LoginCredentials.builder().user(sshUser).password(sshPass).build());
        connection.connect();
        return connection;
    }

    public void testPutAndGet() throws IOException {
        this.temp = File.createTempFile("foo", "bar");
        this.temp.deleteOnExit();
        SshClient client = this.setupClient();
        client.put(this.temp.getAbsolutePath(), (Payload)Payloads.newStringPayload((String)"rabbit"));
        Payload input = client.get(this.temp.getAbsolutePath());
        String contents = Strings2.toString((InputSupplier)input);
        Assert.assertEquals((String)contents, (String)"rabbit");
    }

    public void testGetEtcPassword() throws IOException {
        Payload input = this.setupClient().get("/etc/passwd");
        String contents = Strings2.toString((InputSupplier)input);
        assert (contents.indexOf("root") >= 0) : "no root in " + contents;
    }

    public void testExecHostname() throws IOException, InterruptedException {
        SshClient client = this.setupClient();
        ExecResponse response = client.exec("hostname");
        Assert.assertEquals((String)response.getError(), (String)"");
        Assert.assertEquals((String)response.getOutput().trim(), (String)("localhost".equals(sshHost) ? InetAddress.getLocalHost().getHostName() : sshHost));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecChannelTakesStdinAndNoEchoOfCharsInOuputAndOutlivesClient() throws IOException {
        SshClient client = this.setupClient();
        ExecChannel response = client.execChannel("cat <<EOF");
        client.disconnect();
        Assert.assertEquals((Object)response.getExitStatus().get(), null);
        try {
            PrintStream printStream = new PrintStream(response.getInput());
            printStream.append("foo\n");
            printStream.append("EOF\n");
            printStream.close();
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)response.getError()), (String)"");
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)response.getOutput()), (String)"");
        }
        finally {
            Closeables.closeQuietly((Closeable)response);
        }
        Assert.assertEquals((Object)response.getExitStatus().get(), (Object)0);
    }
}

