/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.IOException;
import org.jclouds.blobstore.functions.ObjectMD5;
import org.jclouds.http.HttpMessage;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ObjectMD5Test {
    private ObjectMD5 fn = new ObjectMD5();

    @Test
    public void testAlreadyHasMD5() {
        Payload payload = Payloads.newPayload((Object)"foo");
        payload.getContentMetadata().setContentMD5(new byte[0]);
        HttpMessage payloadEnclosing = HttpMessage.builder().payload(payload).build();
        Assert.assertEquals((byte[])this.fn.apply((Object)payloadEnclosing), (byte[])new byte[0]);
    }

    @Test
    public void testMD5PayloadEnclosing() throws IOException {
        Payload payload = Payloads.newPayload((Object)"foo");
        HttpMessage payloadEnclosing = HttpMessage.builder().payload(payload).build();
        Assert.assertEquals((byte[])this.fn.apply((Object)payloadEnclosing), (byte[])Hashing.md5().hashString((CharSequence)"foo", Charsets.UTF_8).asBytes());
    }

    @Test
    public void testMD5String() throws IOException {
        Assert.assertEquals((byte[])this.fn.apply((Object)"foo"), (byte[])Hashing.md5().hashString((CharSequence)"foo", Charsets.UTF_8).asBytes());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

