/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ListableMap;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public abstract class BaseMapIntegrationTest<V>
extends BaseBlobStoreIntegrationTest {
    protected Map<String, byte[]> fiveBytes;
    protected Map<String, InputStream> fiveInputs;
    protected Map<String, File> fiveFiles;
    String tmpDirectory;

    public BaseMapIntegrationTest() {
        this.fiveBytes = Maps.transformValues((Map)this.fiveStrings, (Function)new Function<String, byte[]>(){

            public byte[] apply(String from) {
                return from.getBytes();
            }
        });
    }

    public abstract void testPutAll() throws InterruptedException, ExecutionException, TimeoutException;

    public abstract void testEntrySet() throws IOException, InterruptedException, ExecutionException, TimeoutException;

    public abstract void testValues() throws IOException, InterruptedException, ExecutionException, TimeoutException;

    @BeforeMethod(groups={"integration", "live"})
    protected void setUpInputStreams() {
        this.fiveInputs = Maps.transformValues((Map)this.fiveStrings, (Function)new Function<String, InputStream>(){

            public InputStream apply(String from) {
                return Strings2.toInputStream((String)from);
            }
        });
    }

    @BeforeClass(groups={"integration", "live"})
    @Parameters(value={"basedir"})
    protected void setUpTempDir(@Optional String basedir) throws InterruptedException, ExecutionException, FileNotFoundException, IOException, TimeoutException {
        if (basedir == null) {
            basedir = System.getProperty("java.io.tmpdir");
        }
        this.tmpDirectory = basedir + File.separator + "target" + File.separator + "testFiles" + File.separator + ((Object)((Object)this)).getClass().getSimpleName();
        new File(this.tmpDirectory).mkdirs();
        this.fiveFiles = Maps.newHashMap();
        for (Map.Entry entry : this.fiveStrings.entrySet()) {
            File file = new File(this.tmpDirectory, (String)entry.getKey());
            Files.write((byte[])((String)entry.getValue()).getBytes(Charsets.UTF_8), (File)file);
            this.fiveFiles.put((String)entry.getKey(), file);
        }
    }

    protected abstract Map<String, V> createMap(BlobStoreContext var1, String var2);

    protected abstract Map<String, V> createMap(BlobStoreContext var1, String var2, ListContainerOptions var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testClear() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerNameName = this.getContainerName();
        try {
            Map<String, V> map = this.createMap((BlobStoreContext)this.view, containerNameName);
            this.assertConsistencyAwareMapSize(map, 0);
            this.putStringWithMD5(map, "one", "apple");
            this.assertConsistencyAwareMapSize(map, 1);
            map.clear();
            this.assertConsistencyAwareMapSize(map, 0);
        }
        finally {
            this.returnContainer(containerNameName);
        }
    }

    @Test(groups={"integration", "live"})
    public abstract void testRemove() throws IOException, InterruptedException, ExecutionException, TimeoutException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testKeySet() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerNameName = this.getContainerName();
        try {
            Map<String, V> map = this.createMap((BlobStoreContext)this.view, containerNameName);
            this.assertConsistencyAwareKeySize(map, 0);
            this.putStringWithMD5(map, "one", "two");
            this.assertConsistencyAwareKeySize(map, 1);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)ImmutableSet.of((Object)"one"));
        }
        finally {
            this.returnContainer(containerNameName);
        }
    }

    protected void addTenObjectsUnderPrefix(String containerName, String prefix) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(prefix + "/" + i).payload(i + "content").build());
        }
    }

    protected void addTenObjectsUnderRoot(String containerName) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(i + "").payload(i + "content").build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testDirectory() throws InterruptedException {
        String containerName = this.getContainerName();
        String directory = "apps";
        Map<String, V> rootMap = this.createMap((BlobStoreContext)this.view, containerName);
        Map<String, V> rootRecursiveMap = this.createMap((BlobStoreContext)this.view, containerName, ListContainerOptions.Builder.recursive());
        Map<String, V> inDirectoryMap = this.createMap((BlobStoreContext)this.view, containerName, ListContainerOptions.Builder.inDirectory((String)directory));
        Map<String, V> inDirectoryRecursiveMap = this.createMap((BlobStoreContext)this.view, containerName, ListContainerOptions.Builder.inDirectory((String)directory).recursive());
        try {
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory);
            this.addTenObjectsUnderRoot(containerName);
            Assert.assertEquals((int)rootMap.size(), (int)10);
            Assert.assertEquals((Set)ImmutableSortedSet.copyOf(rootMap.keySet()), (Set)ImmutableSortedSet.of((Comparable)((Object)"0"), (Comparable)((Object)"1"), (Comparable)((Object)"2"), (Comparable)((Object)"3"), (Comparable)((Object)"4"), (Comparable)((Object)"5"), (Comparable[])new String[]{"6", "7", "8", "9"}));
            Assert.assertEquals((int)rootRecursiveMap.size(), (int)10);
            Assert.assertEquals((Set)ImmutableSortedSet.copyOf(rootRecursiveMap.keySet()), (Set)ImmutableSortedSet.of((Comparable)((Object)"0"), (Comparable)((Object)"1"), (Comparable)((Object)"2"), (Comparable)((Object)"3"), (Comparable)((Object)"4"), (Comparable)((Object)"5"), (Comparable[])new String[]{"6", "7", "8", "9"}));
            Assert.assertEquals((int)inDirectoryMap.size(), (int)0);
            Assert.assertEquals((int)inDirectoryRecursiveMap.size(), (int)0);
            this.addTenObjectsUnderPrefix(containerName, directory);
            Assert.assertEquals((int)rootMap.size(), (int)10);
            Assert.assertEquals((Set)ImmutableSortedSet.copyOf(rootMap.keySet()), (Set)ImmutableSortedSet.of((Comparable)((Object)"0"), (Comparable)((Object)"1"), (Comparable)((Object)"2"), (Comparable)((Object)"3"), (Comparable)((Object)"4"), (Comparable)((Object)"5"), (Comparable[])new String[]{"6", "7", "8", "9"}));
            Assert.assertEquals((int)rootRecursiveMap.size(), (int)20);
            Assert.assertEquals((Set)ImmutableSortedSet.copyOf(rootRecursiveMap.keySet()), (Set)ImmutableSet.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object[])new String[]{"6", "7", "8", "9", "apps/0", "apps/1", "apps/2", "apps/3", "apps/4", "apps/5", "apps/6", "apps/7", "apps/8", "apps/9"}));
            Assert.assertEquals((int)inDirectoryMap.size(), (int)10);
            Assert.assertEquals((Set)ImmutableSortedSet.copyOf(inDirectoryMap.keySet()), (Set)ImmutableSortedSet.of((Comparable)((Object)"0"), (Comparable)((Object)"1"), (Comparable)((Object)"2"), (Comparable)((Object)"3"), (Comparable)((Object)"4"), (Comparable)((Object)"5"), (Comparable[])new String[]{"6", "7", "8", "9"}));
            Assert.assertEquals((int)inDirectoryRecursiveMap.size(), (int)10);
            Assert.assertEquals((Set)ImmutableSortedSet.copyOf(inDirectoryRecursiveMap.keySet()), (Set)ImmutableSortedSet.of((Comparable)((Object)"0"), (Comparable)((Object)"1"), (Comparable)((Object)"2"), (Comparable)((Object)"3"), (Comparable)((Object)"4"), (Comparable)((Object)"5"), (Comparable[])new String[]{"6", "7", "8", "9"}));
            ((BlobStoreContext)this.view).getBlobStore().createDirectory(containerName, directory + "/" + directory);
            Assert.assertEquals((int)rootMap.size(), (int)10);
            Assert.assertEquals((int)rootRecursiveMap.size(), (int)20);
            Assert.assertEquals((int)inDirectoryMap.size(), (int)10);
            Assert.assertEquals((int)inDirectoryRecursiveMap.size(), (int)10);
            rootMap.clear();
            Assert.assertEquals((int)rootMap.size(), (int)0);
            Assert.assertEquals((int)rootRecursiveMap.size(), (int)10);
            Assert.assertEquals((int)inDirectoryMap.size(), (int)10);
            Assert.assertEquals((int)inDirectoryRecursiveMap.size(), (int)10);
            inDirectoryMap.clear();
            Assert.assertEquals((int)rootMap.size(), (int)0);
            Assert.assertEquals((int)rootRecursiveMap.size(), (int)0);
            Assert.assertEquals((int)inDirectoryMap.size(), (int)0);
            Assert.assertEquals((int)inDirectoryRecursiveMap.size(), (int)0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void assertConsistencyAwareKeySetEquals(final Map<String, V> map, final Set<String> expected) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Set toMatch = map.keySet();
                Sets.SetView shouldBeEmpty = Sets.difference((Set)expected, toMatch);
                assert (shouldBeEmpty.size() == 0) : "toMatch has less keys than expected. missing: " + shouldBeEmpty;
                shouldBeEmpty = Sets.difference(toMatch, (Set)expected);
                assert (shouldBeEmpty.size() == 0) : "toMatch has more keys than expected. extras: " + shouldBeEmpty;
                Assert.assertEquals((Set)Sets.newTreeSet(toMatch), (Set)Sets.newTreeSet((Iterable)expected));
            }
        });
    }

    protected void assertConsistencyAwareRemoveEquals(final Map<String, V> map, final String key, final Object equals) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals(map.remove(key), (Object)equals);
            }
        });
    }

    protected void assertConsistencyAwareGetEquals(final Map<String, V> map, final String key, final Object equals) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals(map.get(key), (Object)equals);
            }
        });
    }

    protected void assertConsistencyAwareKeySize(final Map<String, V> map, final int size) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((int)map.keySet().size(), (int)size);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContainsKey() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerNameName = this.getContainerName();
        try {
            Map<String, V> map = this.createMap((BlobStoreContext)this.view, containerNameName);
            this.assertConsistencyAwareDoesntContainKey(map);
            this.putStringWithMD5(map, "one", "apple");
            this.assertConsistencyAwareContainsKey(map);
        }
        finally {
            this.returnContainer(containerNameName);
        }
    }

    protected void assertConsistencyAwareContainsValue(final Map<String, V> map, final Object value) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                assert (map.containsValue(value));
            }
        });
    }

    protected void assertConsistencyAwareContainsKey(final Map<String, V> map) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                assert (map.containsKey("one"));
            }
        });
    }

    protected void assertConsistencyAwareDoesntContainKey(final Map<String, V> map) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                assert (!map.containsKey("one"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testIsEmpty() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String containerNameName = this.getContainerName();
        try {
            Map<String, V> map = this.createMap((BlobStoreContext)this.view, containerNameName);
            this.assertConsistencyAwareEmpty(map);
            this.putStringWithMD5(map, "one", "apple");
            this.assertConsistencyAwareNotEmpty(map);
        }
        finally {
            this.returnContainer(containerNameName);
        }
    }

    protected void assertConsistencyAwareNotEmpty(final Map<String, V> map) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                assert (!map.isEmpty());
            }
        });
    }

    protected void assertConsistencyAwareEmpty(final Map<String, V> map) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                assert (map.isEmpty());
            }
        });
    }

    protected abstract void putStringWithMD5(Map<String, V> var1, String var2, String var3) throws InterruptedException, ExecutionException, TimeoutException, IOException;

    protected void fourLeftRemovingOne(Map<String, V> map) throws InterruptedException {
        map.remove("one");
        this.assertConsistencyAwareMapSize(map, 4);
        this.assertConsistencyAwareKeySetEquals(map, new TreeSet<String>((Collection<String>)ImmutableSet.of((Object)"two", (Object)"three", (Object)"four", (Object)"five")));
    }

    protected void assertConsistencyAwareMapSize(final Map<String, V> map, final int size) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((int)map.size(), (int)size);
            }
        });
    }

    @Test(groups={"integration", "live"})
    public abstract void testPut() throws IOException, InterruptedException, ExecutionException, TimeoutException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testListContainer() throws InterruptedException, ExecutionException, TimeoutException {
        String containerNameName = this.getContainerName();
        try {
            ListableMap map = (ListableMap)this.createMap((BlobStoreContext)this.view, containerNameName);
            this.assertConsistencyAwareListContainer(map, containerNameName);
        }
        finally {
            this.returnContainer(containerNameName);
        }
    }

    protected void assertConsistencyAwareListContainer(final ListableMap<?, ?> map, String containerNameName) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Assert.assertTrue((Iterables.size((Iterable)map.list()) >= 0 ? 1 : 0) != 0);
            }
        });
    }
}

