/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import org.jclouds.blobstore.options.ListContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ListOptionsTest {
    @Test
    public void testRecursive() {
        ListContainerOptions options = new ListContainerOptions();
        options.recursive();
        Assert.assertTrue((boolean)options.isRecursive());
    }

    @Test
    public void testRecursiveStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.recursive();
        Assert.assertTrue((boolean)options.isRecursive());
    }

    @Test
    public void testPath() {
        ListContainerOptions options = new ListContainerOptions();
        options.inDirectory("test");
        Assert.assertEquals((String)options.getDir(), (String)"test");
    }

    @Test
    public void testPathStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.inDirectory((String)"test");
        Assert.assertEquals((String)options.getDir(), (String)"test");
    }

    @Test
    public void testTwoOptions() {
        ListContainerOptions options = new ListContainerOptions();
        options.inDirectory("test").maxResults(1);
        Assert.assertEquals((String)options.getDir(), (String)"test");
        Assert.assertEquals((Object)options.getMaxResults(), (Object)1);
    }

    @Test
    public void testNullPath() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((String)options.getDir(), null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPathNPE() {
        ListContainerOptions.Builder.inDirectory(null);
    }

    @Test
    public void testMarker() {
        ListContainerOptions options = new ListContainerOptions();
        options.afterMarker("test");
        Assert.assertEquals((String)options.getMarker(), (String)"test");
    }

    @Test
    public void testNullMarker() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((String)options.getMarker(), null);
    }

    @Test
    public void testMarkerStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.afterMarker((String)"test");
        Assert.assertEquals((String)options.getMarker(), (String)"test");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testMarkerNPE() {
        ListContainerOptions.Builder.afterMarker(null);
    }

    @Test
    public void testMaxResults() {
        ListContainerOptions options = new ListContainerOptions();
        options.maxResults(1000);
        Assert.assertEquals((Object)options.getMaxResults(), (Object)1000);
    }

    @Test
    public void testNullMaxResults() {
        ListContainerOptions options = new ListContainerOptions();
        Assert.assertEquals((Object)options.getMaxResults(), null);
    }

    @Test
    public void testMaxResultsStatic() {
        ListContainerOptions options = ListContainerOptions.Builder.maxResults((int)1000);
        Assert.assertEquals((Object)options.getMaxResults(), (Object)1000);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMaxResultsNegative() {
        ListContainerOptions.Builder.maxResults((int)-1);
    }
}

