/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim.xml;

import java.io.InputStream;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ResourceAllocationSettingDataHandlerTest")
public class ResourceAllocationSettingDataHandlerTest
extends BaseHandlerTest {
    public void testNormal() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/resourceallocation.xml");
        ResourceAllocationSettingData result = (ResourceAllocationSettingData)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ResourceAllocationSettingDataHandler.class)).parse(is);
        ResourceAllocationSettingData expects = ResourceAllocationSettingData.builder().allocationUnits("Gigabytes").caption("1234568").description("Hard Disk").elementName("D:\\").hostResource("data").instanceID("6").resourceType(ResourceAllocationSettingData.ResourceType.PARTITIONABLE_UNIT).virtualQuantity(Long.valueOf(50L)).build();
        Assert.assertEquals((String)result.toString(), (String)expects.toString());
    }

    public void testHosting() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/resourceallocation-hosting.xml");
        ResourceAllocationSettingData result = (ResourceAllocationSettingData)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ResourceAllocationSettingDataHandler.class)).parse(is);
        ResourceAllocationSettingData expects = ResourceAllocationSettingData.builder().elementName("1 virtual CPU(s)").allocationUnits("hertz * 10^6").instanceID("1").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(1L)).description("Number of Virtual CPUs").virtualQuantityUnits("count").build();
        Assert.assertEquals((String)result.toString(), (String)expects.toString());
    }
}

