/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ComputeServicePropertiesTest")
public class ComputeServicePropertiesTest {
    public void testDefaultInitStatusProperties() {
        ComputeServiceConstants.InitStatusProperties props = (ComputeServiceConstants.InitStatusProperties)ContextBuilder.newBuilder((String)"stub").buildInjector().getInstance(ComputeServiceConstants.InitStatusProperties.class);
        Assert.assertEquals((long)props.initStatusInitialPeriod, (long)500L);
        Assert.assertEquals((long)props.initStatusMaxPeriod, (long)5000L);
    }

    public void testOverrideInitStatusProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.compute.init-status.initial-period", "501");
        overrides.setProperty("jclouds.compute.init-status.max-period", "5001");
        ComputeServiceConstants.InitStatusProperties props = (ComputeServiceConstants.InitStatusProperties)ContextBuilder.newBuilder((String)"stub").overrides(overrides).buildInjector().getInstance(ComputeServiceConstants.InitStatusProperties.class);
        Assert.assertEquals((long)props.initStatusInitialPeriod, (long)501L);
        Assert.assertEquals((long)props.initStatusMaxPeriod, (long)5001L);
    }

    public void testDefaultPollPeriod() {
        ComputeServiceConstants.PollPeriod props = (ComputeServiceConstants.PollPeriod)ContextBuilder.newBuilder((String)"stub").buildInjector().getInstance(ComputeServiceConstants.PollPeriod.class);
        Assert.assertEquals((long)props.pollInitialPeriod, (long)50L);
        Assert.assertEquals((long)props.pollMaxPeriod, (long)1000L);
    }

    public void testOverridePollPeriod() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.compute.poll-status.initial-period", "501");
        overrides.setProperty("jclouds.compute.poll-status.max-period", "5001");
        ComputeServiceConstants.PollPeriod props = (ComputeServiceConstants.PollPeriod)ContextBuilder.newBuilder((String)"stub").overrides(overrides).buildInjector().getInstance(ComputeServiceConstants.PollPeriod.class);
        Assert.assertEquals((long)props.pollInitialPeriod, (long)501L);
        Assert.assertEquals((long)props.pollMaxPeriod, (long)5001L);
    }
}

