/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.config.PersistNodeCredentialsModule;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PersistNodeCredentialsTest {
    public void testReturnsCorrectFunction() {
        PersistNodeCredentials persistNodeCredentials = (PersistNodeCredentials)Guice.createInjector((Module[])new Module[]{new PersistNodeCredentialsModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Map<String, Credentials>>(){}).toInstance((Object)ImmutableMap.of());
            }
        }}).getInstance(PersistNodeCredentials.class);
        Assert.assertEquals(persistNodeCredentials.always(null).getClass(), PersistNodeCredentialsModule.RefreshCredentialsForNode.class);
        Assert.assertEquals(persistNodeCredentials.ifAdminAccess(null).getClass(), PersistNodeCredentialsModule.RefreshCredentialsForNodeIfRanAdminAccess.class);
    }

    public void testRefreshCredentialsForNodeIfRanAdminAccessWhenStatementIsNullSameCredentialsAndNoCaching() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        EasyMock.replay((Object[])new Object[]{credstore});
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build();
        PersistNodeCredentialsModule.RefreshCredentialsForNodeIfRanAdminAccess fn = new PersistNodeCredentialsModule.RefreshCredentialsForNodeIfRanAdminAccess(credstore, null);
        Assert.assertEquals((Object)node, (Object)fn.apply(node));
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testRefreshCredentialsForNodeWhenStatementIsNullSameCredentialsAndDoesCache() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        LoginCredentials credentials = (LoginCredentials)EasyMock.createMock(LoginCredentials.class);
        EasyMock.expect((Object)credstore.put("node#id", credentials)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{credstore});
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(credentials).build();
        PersistNodeCredentialsModule.RefreshCredentialsForNode fn = new PersistNodeCredentialsModule.RefreshCredentialsForNode(credstore, null);
        Assert.assertEquals((Object)node, (Object)fn.apply(node));
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testRefreshCredentialsForNodeIfRanAdminAccessWhenStatementIsAdminAccessNewCredentialsAndDoesCache() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        LoginCredentials credentials = LoginCredentials.builder().user("foo").build();
        EasyMock.expect((Object)statement.getAdminCredentials()).andReturn((Object)credentials).atLeastOnce();
        EasyMock.expect((Object)credstore.put("node#id", credentials)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{credstore});
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build();
        PersistNodeCredentialsModule.RefreshCredentialsForNodeIfRanAdminAccess fn = new PersistNodeCredentialsModule.RefreshCredentialsForNodeIfRanAdminAccess(credstore, (Statement)statement);
        Assert.assertEquals((Object)fn.apply(node).getCredentials(), (Object)credentials);
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{credstore});
    }

    public void testRefreshCredentialsForNodeWhenStatementIsAdminAccessNewCredentialsAndDoesCache() {
        Map credstore = (Map)EasyMock.createMock(Map.class);
        AdminAccess statement = (AdminAccess)EasyMock.createMock(AdminAccess.class);
        LoginCredentials credentials = LoginCredentials.builder().user("foo").build();
        EasyMock.expect((Object)statement.getAdminCredentials()).andReturn((Object)credentials).atLeastOnce();
        EasyMock.expect((Object)credstore.put("node#id", credentials)).andReturn(null);
        EasyMock.expect((Object)credstore.put("node#id", credentials)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{statement});
        EasyMock.replay((Object[])new Object[]{credstore});
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).build();
        PersistNodeCredentialsModule.RefreshCredentialsForNode fn = new PersistNodeCredentialsModule.RefreshCredentialsForNode(credstore, (Statement)statement);
        Assert.assertEquals((Object)fn.apply(node).getCredentials(), (Object)credentials);
        EasyMock.verify((Object[])new Object[]{statement});
        EasyMock.verify((Object[])new Object[]{credstore});
    }
}

