/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import javax.inject.Provider;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="TemplateBuilderSpecTest")
public class TemplateBuilderSpecTest {
    Provider<TemplateBuilder> templateBuilders = ContextBuilder.newBuilder((String)"stub").buildInjector().getProvider(TemplateBuilder.class);

    public void testParse_empty() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence((TemplateBuilder)this.templateBuilders.get(), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_hardwareId() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"hardwareId=m1.small");
        Assert.assertEquals((String)spec.hardwareId, (String)"m1.small");
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).hardwareId("m1.small"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_hardwareIdRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"hardwareId=m1.small, hardwareId=t1.micro");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_hardwareIdNotCompatibleWithHardwareValues() {
        try {
            TemplateBuilderSpec.parse((String)"hardwareId=m1.small,minCores=1");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"hardwareId=m1.small,minRam=512");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"hardwareId=m1.small,hypervisorMatches=OpenVZ");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_minCores() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"minCores=32");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertEquals((int)32, (int)spec.minCores.intValue());
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).minCores(32.0), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_minCoresRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"minCores=10, minCores=20");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_minRam() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"minRam=10");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertEquals((int)spec.minRam, (int)10);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).minRam(10), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_minDisk() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"minDisk=10");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertEquals((Object)spec.minDisk, (Object)10.0);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).minRam(10), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_minDiskIsNotEqual() {
        TemplateBuilderSpec spec1 = TemplateBuilderSpec.parse((String)"minDisk=10");
        TemplateBuilderSpec spec2 = TemplateBuilderSpec.parse((String)"minDisk=20");
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).minDisk(10.0), ((TemplateBuilder)this.templateBuilders.get()).from(spec1));
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).minDisk(20.0), ((TemplateBuilder)this.templateBuilders.get()).from(spec2));
        Assert.assertNotEquals((Object)spec1.minDisk, (Object)spec2.minDisk);
    }

    public void testParse_minRamRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"minRam=10, minRam=20");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_hypervisorMatches() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"hypervisorMatches=OpenVZ");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertEquals((String)spec.hypervisorMatches, (String)"OpenVZ");
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).hypervisorMatches("OpenVZ"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_hypervisorMatchesRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"hypervisorMatches=VSphere, hypervisorMatches=OpenVZ");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_imageId() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertEquals((String)spec.imageId, (String)"us-east-1/ami-fffffff");
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).imageId("us-east-1/ami-fffffff"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_imageIdRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff, imageId=ami-eeeeeee");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_imageIdNotCompatibleWithImageValues() {
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff,imageNameMatches=foo");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff,osFamily=UBUNTU");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff,osVersionMatches=10.04");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff,os64Bit=true");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff,osArchMatches=x86");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            TemplateBuilderSpec.parse((String)"imageId=us-east-1/ami-fffffff,osDescriptionMatches=^((?!MGC).)*$");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_imageNameMatches() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"imageNameMatches=.*w/ None.*");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertEquals((String)spec.imageNameMatches, (String)".*w/ None.*");
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).imageNameMatches(".*w/ None.*"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_imageNameMatchesRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"imageNameMatches=hello, imageNameMatches=.*w/ None.*");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_osFamily() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"osFamily=UBUNTU");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertEquals((Object)spec.osFamily, (Object)OsFamily.UBUNTU);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).osFamily(OsFamily.UBUNTU), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_osFamilyRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"osFamily=UBUNTU, osFamily=LINUX");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_osVersionMatches() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"osVersionMatches=.*[Aa]utomated SSH Access.*");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertEquals((String)spec.osVersionMatches, (String)".*[Aa]utomated SSH Access.*");
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).osVersionMatches(".*[Aa]utomated SSH Access.*"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_osVersionMatchesRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"osVersionMatches=11.04, osVersionMatches=.*[Aa]utomated SSH Access.*");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_os64Bit() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"os64Bit=true");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertEquals((boolean)spec.os64Bit, (boolean)true);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).os64Bit(true), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_os64BitRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"os64Bit=false, os64Bit=true");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_osArchMatches() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"osArchMatches=x86");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertEquals((String)spec.osArchMatches, (String)"x86");
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).osArchMatches("x86"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_osArchMatchesRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"osArchMatches=x86, osArchMatches=foo");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_osDescriptionMatches() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"osDescriptionMatches=^((?!MGC).)*$");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertEquals((String)spec.osDescriptionMatches, (String)"^((?!MGC).)*$");
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).osDescriptionMatches("^((?!MGC).)*$"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_osDescriptionMatchesRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"osDescriptionMatches=^((?!MGC).)*$, osDescriptionMatches=.*[Aa]utomated SSH Access.*");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_loginUser() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"loginUser=ubuntu");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertEquals((String)spec.loginUser, (String)"ubuntu");
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).options(TemplateOptions.Builder.overrideLoginUser((String)"ubuntu")), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_loginUserRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"loginUser=aws-user,loginUser=ubuntu");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_loginUserWithPassword() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"loginUser=root:toor");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertEquals((String)spec.loginUser, (String)"root:toor");
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).options(TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)LoginCredentials.builder().user("root").password("toor").build())), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_authenticateSudoWithoutLoginUser() {
        try {
            TemplateBuilderSpec.parse((String)"authenticateSudo=true");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_authenticateSudo() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"loginUser=root:toor,authenticateSudo=true");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertEquals((String)spec.loginUser, (String)"root:toor");
        Assert.assertEquals((boolean)spec.authenticateSudo, (boolean)true);
        Assert.assertNull((Object)spec.locationId);
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).options(TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)LoginCredentials.builder().user("root").password("toor").authenticateSudo(true).build())), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_authenticateSudoRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"loginUser=root:toor,authenticateSudo=true,authenticateSudo=false");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_locationId() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"locationId=stub");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertNull((Object)spec.osFamily);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertEquals((String)spec.locationId, (String)"stub");
        this.assertTemplateBuilderEquivalence(((TemplateBuilder)this.templateBuilders.get()).locationId("stub"), ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_locationIdRepeated() {
        try {
            TemplateBuilderSpec.parse((String)"locationId=stub, locationId=stub");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_multipleKeys() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"osFamily=UBUNTU,osVersionMatches=1[012].[01][04],imageNameMatches=.*w/ None.*");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertNull((Object)spec.minRam);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertEquals((String)spec.imageNameMatches, (String)".*w/ None.*");
        Assert.assertEquals((Object)spec.osFamily, (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)spec.osVersionMatches, (String)"1[012].[01][04]");
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        TemplateBuilder expected = ((TemplateBuilder)this.templateBuilders.get()).osVersionMatches("1[012].[01][04]").imageNameMatches(".*w/ None.*").osFamily(OsFamily.UBUNTU);
        this.assertTemplateBuilderEquivalence(expected, ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testParse_whitespaceAllowed() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)" minRam=10,\nosFamily=UBUNTU");
        Assert.assertNull((Object)spec.hardwareId);
        Assert.assertNull((Object)spec.minCores);
        Assert.assertEquals((int)spec.minRam, (int)10);
        Assert.assertNull((Object)spec.minDisk);
        Assert.assertNull((Object)spec.hypervisorMatches);
        Assert.assertNull((Object)spec.imageId);
        Assert.assertNull((Object)spec.imageNameMatches);
        Assert.assertEquals((Object)spec.osFamily, (Object)OsFamily.UBUNTU);
        Assert.assertNull((Object)spec.osVersionMatches);
        Assert.assertNull((Object)spec.os64Bit);
        Assert.assertNull((Object)spec.osArchMatches);
        Assert.assertNull((Object)spec.osDescriptionMatches);
        Assert.assertNull((Object)spec.loginUser);
        Assert.assertNull((Object)spec.authenticateSudo);
        Assert.assertNull((Object)spec.locationId);
        TemplateBuilder expected = ((TemplateBuilder)this.templateBuilders.get()).minRam(10).osFamily(OsFamily.UBUNTU);
        this.assertTemplateBuilderEquivalence(expected, ((TemplateBuilder)this.templateBuilders.get()).from(spec));
    }

    public void testNiceJson() {
        TemplateBuilderSpec spec = TemplateBuilderSpec.parse((String)"osFamily=UBUNTU,osVersionMatches=1[012].[01][04],imageNameMatches=.*w/ None.*");
        Assert.assertEquals((String)new Gson().toJson((Object)spec), (String)"{\"imageNameMatches\":\".*w/ None.*\",\"osFamily\":\"UBUNTU\",\"osVersionMatches\":\"1[012].[01][04]\"}");
        Assert.assertEquals((Object)new Gson().fromJson(new Gson().toJson((Object)spec), TemplateBuilderSpec.class), (Object)spec);
    }

    public void testParse_unknownKey() {
        try {
            TemplateBuilderSpec.parse((String)"foo=17");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTemplateBuilderFrom_string() {
        TemplateBuilder fromString = ((TemplateBuilder)this.templateBuilders.get()).from("minRam=10,osFamily=UBUNTU");
        TemplateBuilder expected = ((TemplateBuilder)this.templateBuilders.get()).minCores(30.0).minRam(10).osFamily(OsFamily.UBUNTU);
        this.assertTemplateBuilderEquivalence(expected, fromString);
    }

    private void assertTemplateBuilderEquivalence(TemplateBuilder a, TemplateBuilder b) {
        for (Field f : TemplateBuilder.class.getFields()) {
            f.setAccessible(true);
            try {
                Assert.assertEquals((Object)f.get(a), (Object)f.get(b), (String)("Field " + f.getName() + " not equal"));
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e.getMessage());
            }
        }
    }
}

