/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.extensions.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshClient;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseImageExtensionLiveTest
extends BaseComputeServiceContextLiveTest {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected String imageId;

    public Template getNodeTemplate() {
        return ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
    }

    public long getSpawnNodeMaxWait() {
        return 600L;
    }

    protected Iterable<? extends Image> listImages() {
        return ((ComputeServiceContext)this.view).getComputeService().listImages();
    }

    @Test(groups={"integration", "live"}, singleThreaded=true)
    public void testCreateImage() throws RunNodesException, InterruptedException, ExecutionException {
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional imageExtension = computeService.getImageExtension();
        Assert.assertTrue((boolean)imageExtension.isPresent(), (String)"image extension was not present");
        Template template = this.getNodeTemplate();
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test-create-image", 1, template));
        this.checkReachable(node);
        this.logger.info("Creating image from node %s, started with template: %s", new Object[]{node, template});
        ImageTemplate newImageTemplate = ((ImageExtension)imageExtension.get()).buildImageTemplateFromNode("test-create-image", node.getId());
        Image image = (Image)((ImageExtension)imageExtension.get()).createImage(newImageTemplate).get();
        this.logger.info("Image created: %s", new Object[]{image});
        Assert.assertEquals((String)"test-create-image", (String)image.getName());
        this.imageId = image.getId();
        computeService.destroyNode(node.getId());
        Optional<? extends Image> optImage = this.getImage();
        Assert.assertTrue((boolean)optImage.isPresent());
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testCreateImage"})
    public void testSpawnNodeFromImage() throws RunNodesException {
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional<? extends Image> optImage = this.getImage();
        Assert.assertTrue((boolean)optImage.isPresent());
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)computeService.createNodesInGroup("test-create-image", 1, ((ComputeServiceContext)this.view).getComputeService().templateBuilder().imageId(((Image)optImage.get()).getId()).fromImage((Image)optImage.get()).build()));
        this.checkReachable(node);
        ((ComputeServiceContext)this.view).getComputeService().destroyNode(node.getId());
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testCreateImage", "testSpawnNodeFromImage"})
    public void testDeleteImage() {
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional imageExtension = computeService.getImageExtension();
        Assert.assertTrue((boolean)imageExtension.isPresent(), (String)"image extension was not present");
        Optional<? extends Image> optImage = this.getImage();
        Assert.assertTrue((boolean)optImage.isPresent());
        Image image = (Image)optImage.get();
        Assert.assertTrue((boolean)((ImageExtension)imageExtension.get()).deleteImage(image.getId()));
    }

    private Optional<? extends Image> getImage() {
        return Iterables.tryFind(this.listImages(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.getId().equals(BaseImageExtensionLiveTest.this.imageId);
            }
        });
    }

    private void checkReachable(NodeMetadata node) {
        SshClient client = (SshClient)((ComputeServiceContext)this.view).utils().sshForNode().apply((Object)node);
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<SshClient>(){

            public boolean apply(SshClient input) {
                input.connect();
                return input.exec("id").getExitStatus() == 0;
            }
        }, (long)this.getSpawnNodeMaxWait(), (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)client));
    }
}

