/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Predicate;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.jclouds.compute.config.ComputeServiceTimeoutsModule;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.PollNodeRunning;
import org.jclouds.compute.predicates.AtomicNodeRunning;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class PollNodeRunningTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="node\\(id\\) didn't achieve the status running; aborting after 0 seconds with final status: PENDING")
    public void testIllegalStateExceptionWhenNodeStillPending() {
        final NodeMetadata pendingNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.PENDING).build();
        Predicate<AtomicReference<NodeMetadata>> nodeRunning = new Predicate<AtomicReference<NodeMetadata>>(){

            public boolean apply(AtomicReference<NodeMetadata> input) {
                Assert.assertEquals((Object)input.get(), (Object)pendingNode);
                return false;
            }
        };
        AtomicReference atomicNode = Atomics.newReference((Object)pendingNode);
        try {
            new PollNodeRunning((Predicate)nodeRunning).apply(atomicNode);
        }
        finally {
            Assert.assertEquals(atomicNode.get(), (Object)pendingNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="node\\(id\\) terminated")
    public void testIllegalStateExceptionWhenNodeDied() {
        final NodeMetadata pendingNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.PENDING).build();
        final NodeMetadata deadNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.TERMINATED).build();
        Predicate<AtomicReference<NodeMetadata>> nodeRunning = new Predicate<AtomicReference<NodeMetadata>>(){

            public boolean apply(AtomicReference<NodeMetadata> input) {
                Assert.assertEquals((Object)input.get(), (Object)pendingNode);
                input.set(deadNode);
                return false;
            }
        };
        AtomicReference atomicNode = Atomics.newReference((Object)pendingNode);
        try {
            new PollNodeRunning((Predicate)nodeRunning).apply(atomicNode);
        }
        finally {
            Assert.assertEquals(atomicNode.get(), (Object)deadNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="api response for node\\(id\\) was null")
    public void testIllegalStateExceptionAndNodeResetWhenRefSetToNull() {
        final NodeMetadata pendingNode = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.PENDING).build();
        Predicate<AtomicReference<NodeMetadata>> nodeRunning = new Predicate<AtomicReference<NodeMetadata>>(){

            public boolean apply(AtomicReference<NodeMetadata> input) {
                Assert.assertEquals((Object)input.get(), (Object)pendingNode);
                input.set(null);
                return false;
            }
        };
        AtomicReference atomicNode = Atomics.newReference((Object)pendingNode);
        try {
            new PollNodeRunning((Predicate)nodeRunning).apply(atomicNode);
        }
        finally {
            Assert.assertEquals(atomicNode.get(), (Object)pendingNode);
        }
    }

    public void testRecoversWhenTemporarilyNodeNotFound() {
        String nodeId = "myid";
        ComputeServiceConstants.Timeouts timeouts = new ComputeServiceConstants.Timeouts();
        ComputeServiceConstants.PollPeriod period = new ComputeServiceConstants.PollPeriod();
        NodeMetadata pendingNode = new NodeMetadataBuilder().ids(nodeId).status(NodeMetadata.Status.PENDING).build();
        final NodeMetadata runningNode = new NodeMetadataBuilder().ids(nodeId).status(NodeMetadata.Status.RUNNING).build();
        GetNodeMetadataStrategy nodeClient = (GetNodeMetadataStrategy)EasyMock.createMock(GetNodeMetadataStrategy.class);
        AtomicNodeRunning nodeRunning = new AtomicNodeRunning(nodeClient);
        Predicate<AtomicReference<NodeMetadata>> retryableNodeRunning = new ComputeServiceTimeoutsModule(){

            public Predicate<AtomicReference<NodeMetadata>> nodeRunning(AtomicNodeRunning statusRunning, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
                return super.nodeRunning(statusRunning, timeouts, period);
            }
        }.nodeRunning(nodeRunning, timeouts, period);
        AtomicReference atomicNode = Atomics.newReference((Object)pendingNode);
        EasyMock.expect((Object)nodeClient.getNode(nodeId)).andAnswer((IAnswer)new IAnswer<NodeMetadata>(){
            private int count = 0;

            public NodeMetadata answer() throws Throwable {
                ++this.count;
                if (this.count <= 1) {
                    return null;
                }
                return runningNode;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{nodeClient});
        new PollNodeRunning(retryableNodeRunning).apply(atomicNode);
        Assert.assertEquals((Object)((NodeMetadata)atomicNode.get()).getStatus(), (Object)NodeMetadata.Status.RUNNING);
        EasyMock.verify((Object[])new Object[]{nodeClient});
    }
}

