/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.apis.BaseViewLiveTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.rest.config.CredentialStoreModule;

public abstract class BaseGenericComputeServiceContextLiveTest<W extends ComputeServiceContext>
extends BaseViewLiveTest<W> {
    protected TemplateBuilderSpec template;
    protected LoginCredentials loginCredentials = LoginCredentials.builder().user("root").build();
    protected Module credentialStoreModule = new CredentialStoreModule((Map)new CopyInputStreamInputSupplierMap(new ConcurrentHashMap()));

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        String spec = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".template");
        if (spec != null) {
            this.template = TemplateBuilderSpec.parse((String)spec);
            if (this.template.getLoginUser() != null) {
                Iterable userPass = Splitter.on((char)':').split((CharSequence)this.template.getLoginUser());
                LoginCredentials.Builder loginCredentialsBuilder = LoginCredentials.builder();
                loginCredentialsBuilder.user((String)Iterables.get((Iterable)userPass, (int)0));
                if (Iterables.size((Iterable)userPass) == 2) {
                    loginCredentialsBuilder.password((String)Iterables.get((Iterable)userPass, (int)1));
                }
                if (this.template.getAuthenticateSudo() != null) {
                    loginCredentialsBuilder.authenticateSudo(this.template.getAuthenticateSudo().booleanValue());
                }
                this.loginCredentials = loginCredentialsBuilder.build();
            }
        }
        return overrides;
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)this.credentialStoreModule, (Object)this.getSshModule());
    }

    protected Module getSshModule() {
        return Modules.EMPTY_MODULE;
    }
}

